/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.NoSuchElementException;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.options.DescribeImagesOptions;

@Singleton
public class EC2GetImageStrategy
implements GetImageStrategy {
    private final EC2Api client;
    private final Function<org.jclouds.ec2.domain.Image, Image> imageToImage;

    @Inject
    protected EC2GetImageStrategy(EC2Api client, Function<org.jclouds.ec2.domain.Image, Image> imageToImage) {
        this.client = (EC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.imageToImage = (Function)Preconditions.checkNotNull(imageToImage, (Object)"imageToImage");
    }

    public Image getImage(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        String[] parts = AWSUtils.parseHandle((String)id);
        String region = parts[0];
        String instanceId = parts[1];
        try {
            org.jclouds.ec2.domain.Image image = this.getImageInRegion(region, instanceId);
            return (Image)this.imageToImage.apply((Object)image);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public org.jclouds.ec2.domain.Image getImageInRegion(String region, String id) {
        return (org.jclouds.ec2.domain.Image)Iterables.getOnlyElement(((AMIApi)this.client.getAMIApi().get()).describeImagesInRegion(region, DescribeImagesOptions.Builder.imageIds(id)));
    }
}

