/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutionException;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.features.ElasticIPAddressApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.logging.Logger;

@Singleton
public class EC2DestroyNodeStrategy
implements DestroyNodeStrategy {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final EC2Api client;
    protected final GetNodeMetadataStrategy getNode;
    protected final LoadingCache<RegionAndName, String> elasticIpCache;
    @Inject
    @Named(value="jclouds.ec2.auto-allocate-elastic-ips")
    @VisibleForTesting
    boolean autoAllocateElasticIps = false;

    @Inject
    protected EC2DestroyNodeStrategy(EC2Api client, GetNodeMetadataStrategy getNode, @Named(value="ELASTICIP") LoadingCache<RegionAndName, String> elasticIpCache) {
        this.client = (EC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.getNode = (GetNodeMetadataStrategy)Preconditions.checkNotNull((Object)getNode, (Object)"getNode");
        this.elasticIpCache = (LoadingCache)Preconditions.checkNotNull(elasticIpCache, (Object)"elasticIpCache");
    }

    public NodeMetadata destroyNode(String id) {
        String[] parts = AWSUtils.parseHandle((String)id);
        String region = parts[0];
        String instanceId = parts[1];
        this.releaseAnyPublicIpForInstanceInRegion(instanceId, region);
        this.destroyInstanceInRegion(instanceId, region);
        return this.getNode.getNode(id);
    }

    protected void releaseAnyPublicIpForInstanceInRegion(String instanceId, String region) {
        if (!this.autoAllocateElasticIps) {
            return;
        }
        try {
            String ip = (String)this.elasticIpCache.get((Object)new RegionAndName(region, instanceId));
            this.logger.debug(">> disassociating elastic IP %s", new Object[]{ip});
            ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).disassociateAddressInRegion(region, ip);
            this.logger.trace("<< disassociated elastic IP %s", new Object[]{ip});
            this.elasticIpCache.invalidate((Object)new RegionAndName(region, instanceId));
            this.logger.debug(">> releasing elastic IP %s", new Object[]{ip});
            ((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).releaseAddressInRegion(region, ip);
            this.logger.trace("<< released elastic IP %s", new Object[]{ip});
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return;
        }
        catch (ExecutionException e) {
            this.logger.warn((Throwable)e, "error cleaning up elastic ip for instance %s/%s", new Object[]{region, instanceId});
        }
    }

    protected void destroyInstanceInRegion(String instanceId, String region) {
        ((InstanceApi)this.client.getInstanceApi().get()).terminateInstancesInRegion(region, instanceId);
    }
}

