/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.loaders;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.NoSuchElementException;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.domain.PublicIpInstanceIdPair;
import org.jclouds.ec2.features.ElasticIPAddressApi;

@Singleton
public class LoadPublicIpForInstanceOrNull
extends CacheLoader<RegionAndName, String> {
    private final EC2Api client;

    @Inject
    public LoadPublicIpForInstanceOrNull(EC2Api client) {
        this.client = client;
    }

    public String load(final RegionAndName key) throws Exception {
        try {
            return ((PublicIpInstanceIdPair)Iterables.find(((ElasticIPAddressApi)this.client.getElasticIPAddressApi().get()).describeAddressesInRegion(key.getRegion(), new String[0]), (Predicate)new Predicate<PublicIpInstanceIdPair>(){

                public boolean apply(PublicIpInstanceIdPair input) {
                    return key.getName().equals(input.getInstanceId());
                }
            })).getPublicIp();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

