/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutionException;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.ec2.compute.domain.RegionAndName;

@Singleton
public class AddElasticIpsToNodemetadata
implements Function<NodeMetadata, NodeMetadata> {
    private final LoadingCache<RegionAndName, String> cache;

    @Inject
    protected AddElasticIpsToNodemetadata(@Named(value="ELASTICIP") LoadingCache<RegionAndName, String> cache) {
        this.cache = (LoadingCache)Preconditions.checkNotNull(cache, (Object)"cache");
    }

    public NodeMetadata apply(NodeMetadata arg0) {
        String[] parts = AWSUtils.parseHandle((String)arg0.getId());
        String region = parts[0];
        String instanceId = parts[1];
        try {
            String publicIp = (String)this.cache.get((Object)new RegionAndName(region, instanceId));
            return NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)arg0).publicAddresses((Iterable)ImmutableSet.builder().add((Object)publicIp).build()).build();
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return arg0;
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

