/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindUserGroupsToIndexedFormParams
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof Iterable), (Object)("this binder is only valid for Iterable<?>: " + String.valueOf(input.getClass())));
        this.checkValidUserGroup(input);
        return (R)AWSUtils.indexIterableToFormValuesWithPrefix(request, (String)"UserGroup", (Object)input);
    }

    private void checkValidUserGroup(Object input) {
        Iterable values = (Iterable)input;
        long size = Iterables.size((Iterable)values);
        Preconditions.checkArgument((size == 0L || size == 1L && Iterables.getOnlyElement((Iterable)values).equals("all") ? 1 : 0) != 0, (Object)"only supported UserGroup is 'all'");
    }
}

