/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.EC2ComputeServiceContext;
import org.jclouds.ec2.compute.config.EC2ComputeServiceContextModule;
import org.jclouds.ec2.compute.config.EC2ResolveImagesModule;
import org.jclouds.ec2.config.EC2HttpApiModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value={ApiMetadata.class})
public final class EC2ApiMetadata
extends BaseHttpApiMetadata<EC2Api> {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public EC2ApiMetadata() {
        super((BaseHttpApiMetadata.Builder)new Builder());
    }

    protected EC2ApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.aws.auth.tag", "AWS");
        properties.setProperty("jclouds.aws.header.tag", "amz");
        properties.setProperty("jclouds.ec2.ami-owners", "*");
        properties.setProperty("jclouds.ec2.timeout.securitygroup-present", "500");
        properties.setProperty("jclouds.ec2.auto-allocate-elastic-ips", "false");
        properties.setProperty("jclouds.compute.resourcename-delimiter", "#");
        properties.setProperty("jclouds.ec2.generate-instance-names", "true");
        return properties;
    }

    public static final class Builder
    extends BaseHttpApiMetadata.Builder<EC2Api, Builder> {
        public Builder() {
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("ec2")).name("Amazon Elastic Compute Cloud (EC2) API")).identityName("Access Key ID")).credentialName("Secret Access Key")).defaultEndpoint("https://ec2.us-east-1.amazonaws.com")).documentation(URI.create("http://docs.amazonwebservices.com/AWSEC2/latest/APIReference"))).version("2010-08-31")).defaultProperties(EC2ApiMetadata.defaultProperties())).view(EC2ComputeServiceContext.class)).defaultModules((Set)ImmutableSet.of(EC2HttpApiModule.class, EC2ResolveImagesModule.class, EC2ComputeServiceContextModule.class));
        }

        public ApiMetadata build() {
            return new EC2ApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

