/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import org.jclouds.logging.Logger;

public final class MultipartUploadSlicingAlgorithm {
    private final long minimumPartSize;
    private final long maximumPartSize;
    private final int maximumNumberOfParts;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    public static final long DEFAULT_PART_SIZE = 0x2000000L;
    @VisibleForTesting
    static final int DEFAULT_MAGNITUDE_BASE = 100;
    @Inject(optional=true)
    @Named(value="jclouds.mpu.parts.size")
    @VisibleForTesting
    long defaultPartSize = 0x2000000L;
    @Inject(optional=true)
    @Named(value="jclouds.mpu.parts.magnitude")
    @VisibleForTesting
    int magnitudeBase = 100;
    private volatile int parts;
    private volatile long chunkSize;
    private volatile long remaining;
    private volatile int part;
    private volatile long chunkOffset;
    private volatile long copied;

    public MultipartUploadSlicingAlgorithm(long minimumPartSize, long maximumPartSize, int maximumNumberOfParts) {
        Preconditions.checkArgument((minimumPartSize > 0L ? 1 : 0) != 0);
        this.minimumPartSize = minimumPartSize;
        Preconditions.checkArgument((maximumPartSize > 0L ? 1 : 0) != 0);
        this.maximumPartSize = maximumPartSize;
        Preconditions.checkArgument((maximumNumberOfParts > 0 ? 1 : 0) != 0);
        this.maximumNumberOfParts = maximumNumberOfParts;
    }

    public long calculateChunkSize(long length) {
        long remainder;
        long unitPartSize = this.defaultPartSize;
        int parts = (int)(length / unitPartSize);
        long partSize = unitPartSize;
        int magnitude = parts / this.magnitudeBase;
        if (magnitude > 0) {
            partSize = (long)magnitude * unitPartSize;
            if (partSize > this.maximumPartSize) {
                partSize = this.maximumPartSize;
                unitPartSize = this.maximumPartSize;
            }
            if ((long)(parts = (int)(length / partSize)) * partSize < length) {
                partSize = (long)(magnitude + 1) * unitPartSize;
                if (partSize > this.maximumPartSize) {
                    partSize = this.maximumPartSize;
                    unitPartSize = this.maximumPartSize;
                }
                parts = (int)(length / partSize);
            }
        }
        if (partSize < this.minimumPartSize) {
            partSize = this.minimumPartSize;
            unitPartSize = this.minimumPartSize;
            parts = (int)(length / unitPartSize);
        }
        if (partSize > this.maximumPartSize) {
            partSize = this.maximumPartSize;
            unitPartSize = this.maximumPartSize;
            parts = (int)(length / unitPartSize);
        }
        if (parts > this.maximumNumberOfParts) {
            unitPartSize = partSize = length / (long)this.maximumNumberOfParts;
            parts = this.maximumNumberOfParts;
        }
        if ((remainder = length % unitPartSize) == 0L && parts > 0) {
            --parts;
        }
        if (remainder > 0L && parts == this.maximumNumberOfParts) {
            partSize = length / (long)(--parts);
        }
        this.chunkSize = partSize;
        this.parts = parts;
        this.remaining = length - partSize * (long)parts;
        this.logger.debug(" %d bytes partitioned in %d parts of part size: %d, remaining: %d%s", new Object[]{length, parts, this.chunkSize, this.remaining, this.remaining > this.maximumPartSize ? " overflow!" : ""});
        return this.chunkSize;
    }

    public long getCopied() {
        return this.copied;
    }

    public void setCopied(long copied) {
        this.copied = copied;
    }

    public int getParts() {
        return this.parts;
    }

    protected int getNextPart() {
        return ++this.part;
    }

    public void addCopied(long copied) {
        this.copied += copied;
    }

    protected long getNextChunkOffset() {
        long next = this.chunkOffset;
        this.chunkOffset += this.getChunkSize();
        return next;
    }

    @VisibleForTesting
    protected long getChunkSize() {
        return this.chunkSize;
    }

    public long getRemaining() {
        return this.remaining;
    }
}

