/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.javax.annotation.concurrent.NotThreadSafe;
import org.jclouds.logging.Logger;

@NotThreadSafe
public class FetchBlobMetadata
implements Function<PageSet<? extends StorageMetadata>, PageSet<? extends StorageMetadata>> {
    protected final BackoffLimitedRetryHandler retryHandler;
    protected final BlobStore blobstore;
    protected final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.blobstore")
    protected Logger logger = Logger.NULL;
    private String container;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected Long maxTime;

    @Inject
    FetchBlobMetadata(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BlobStore blobstore, BackoffLimitedRetryHandler retryHandler) {
        this.userExecutor = userExecutor;
        this.blobstore = blobstore;
        this.retryHandler = retryHandler;
    }

    public FetchBlobMetadata setContainerName(String container) {
        this.container = container;
        return this;
    }

    public PageSet<? extends StorageMetadata> apply(PageSet<? extends StorageMetadata> in) {
        Preconditions.checkState((this.container != null ? 1 : 0) != 0, (Object)"container name should be initialized");
        if (in == null) {
            return new PageSetImpl(Collections.emptyList(), null);
        }
        LinkedHashMap<String, StorageMetadata> orderedMap = new LinkedHashMap<String, StorageMetadata>(in.size());
        for (StorageMetadata storageMetadata : in) {
            orderedMap.put(storageMetadata.getName(), null);
        }
        ArrayList returnv = Lists.newArrayList((Iterable)FutureIterables.transformParallel(in, (Function)new Function<StorageMetadata, ListenableFuture<? extends StorageMetadata>>(){

            public ListenableFuture<StorageMetadata> apply(final StorageMetadata from) {
                if (from.getType() != StorageType.BLOB) {
                    return Futures.immediateFuture((Object)from);
                }
                return FetchBlobMetadata.this.userExecutor.submit((Callable)new Callable<StorageMetadata>(){

                    @Override
                    public StorageMetadata call() {
                        return FetchBlobMetadata.this.blobstore.blobMetadata(FetchBlobMetadata.this.container, from.getName());
                    }
                });
            }
        }, (ListeningExecutorService)this.userExecutor, (Long)this.maxTime, (Logger)this.logger, (String)String.format("getting metadata from containerName: %s", this.container)));
        for (StorageMetadata storageMetadata : returnv) {
            orderedMap.put(storageMetadata.getName(), storageMetadata);
        }
        return new PageSetImpl(orderedMap.values(), in.getNextMarker());
    }
}

