/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;

public class GetOptions {
    public static final GetOptions NONE = new GetOptions();
    private final List<String> ranges = Lists.newArrayList();
    private Date ifModifiedSince;
    private Date ifUnmodifiedSince;
    private String ifMatch;
    private String ifNoneMatch;

    public GetOptions range(long start, long end) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be >= 0");
        Preconditions.checkArgument((end >= 0L ? 1 : 0) != 0, (Object)"end must be >= 0");
        this.getRanges().add(String.format("%d-%d", start, end));
        return this;
    }

    public GetOptions startAt(long start) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be >= 0");
        this.getRanges().add(String.format("%d-", start));
        return this;
    }

    public GetOptions tail(long length) {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length must be >= 0");
        this.getRanges().add(String.format("-%d", length));
        return this;
    }

    public GetOptions ifModifiedSince(Date ifModifiedSince) {
        Preconditions.checkArgument((this.getIfMatch() == null ? 1 : 0) != 0, (Object)"ifETagMatches() is not compatible with ifModifiedSince()");
        Preconditions.checkArgument((this.getIfUnmodifiedSince() == null ? 1 : 0) != 0, (Object)"ifUnmodifiedSince() is not compatible with ifModifiedSince()");
        this.ifModifiedSince = (Date)Preconditions.checkNotNull((Object)ifModifiedSince, (Object)"ifModifiedSince");
        return this;
    }

    public Date getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public GetOptions ifUnmodifiedSince(Date ifUnmodifiedSince) {
        Preconditions.checkArgument((this.getIfNoneMatch() == null ? 1 : 0) != 0, (Object)"ifETagDoesntMatch() is not compatible with ifUnmodifiedSince()");
        Preconditions.checkArgument((this.getIfModifiedSince() == null ? 1 : 0) != 0, (Object)"ifModifiedSince() is not compatible with ifUnmodifiedSince()");
        this.ifUnmodifiedSince = (Date)Preconditions.checkNotNull((Object)ifUnmodifiedSince, (Object)"ifUnmodifiedSince");
        return this;
    }

    public Date getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public GetOptions ifETagMatches(String eTag) {
        Preconditions.checkArgument((this.getIfNoneMatch() == null ? 1 : 0) != 0, (Object)"ifETagDoesntMatch() is not compatible with ifETagMatches()");
        Preconditions.checkArgument((this.getIfModifiedSince() == null ? 1 : 0) != 0, (Object)"ifModifiedSince() is not compatible with ifETagMatches()");
        this.ifMatch = (String)Preconditions.checkNotNull((Object)eTag, (Object)"eTag");
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public GetOptions ifETagDoesntMatch(String eTag) {
        Preconditions.checkArgument((this.getIfMatch() == null ? 1 : 0) != 0, (Object)"ifETagMatches() is not compatible with ifETagDoesntMatch()");
        Preconditions.checkArgument((this.getIfUnmodifiedSince() == null ? 1 : 0) != 0, (Object)"ifUnmodifiedSince() is not compatible with ifETagDoesntMatch()");
        this.ifNoneMatch = (String)Preconditions.checkNotNull((Object)eTag, (Object)"eTag");
        return this;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public List<String> getRanges() {
        return this.ranges;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ifMatch == null ? 0 : this.ifMatch.hashCode());
        result = 31 * result + (this.ifModifiedSince == null ? 0 : this.ifModifiedSince.hashCode());
        result = 31 * result + (this.ifNoneMatch == null ? 0 : this.ifNoneMatch.hashCode());
        result = 31 * result + (this.ifUnmodifiedSince == null ? 0 : this.ifUnmodifiedSince.hashCode());
        result = 31 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetOptions other = (GetOptions)obj;
        if (this.ifMatch == null ? other.ifMatch != null : !this.ifMatch.equals(other.ifMatch)) {
            return false;
        }
        if (this.ifModifiedSince == null ? other.ifModifiedSince != null : !this.ifModifiedSince.equals(other.ifModifiedSince)) {
            return false;
        }
        if (this.ifNoneMatch == null ? other.ifNoneMatch != null : !this.ifNoneMatch.equals(other.ifNoneMatch)) {
            return false;
        }
        if (this.ifUnmodifiedSince == null ? other.ifUnmodifiedSince != null : !this.ifUnmodifiedSince.equals(other.ifUnmodifiedSince)) {
            return false;
        }
        return !(this.ranges == null ? other.ranges != null : !this.ranges.equals(other.ranges));
    }

    public String toString() {
        return "[ranges=" + String.valueOf(this.ranges) + ", ifModifiedSince=" + String.valueOf(this.ifModifiedSince) + ", ifUnmodifiedSince=" + String.valueOf(this.ifUnmodifiedSince) + ", ifMatch=" + this.ifMatch + ", ifNoneMatch=" + this.ifNoneMatch + "]";
    }

    public static class Builder {
        public static GetOptions range(long start, long end) {
            GetOptions options = new GetOptions();
            return options.range(start, end);
        }

        public static GetOptions ifModifiedSince(Date ifModifiedSince) {
            GetOptions options = new GetOptions();
            return options.ifModifiedSince(ifModifiedSince);
        }

        public static GetOptions ifUnmodifiedSince(Date ifUnmodifiedSince) {
            GetOptions options = new GetOptions();
            return options.ifUnmodifiedSince(ifUnmodifiedSince);
        }

        public static GetOptions ifETagMatches(String eTag) {
            GetOptions options = new GetOptions();
            return options.ifETagMatches(eTag);
        }

        public static GetOptions ifETagDoesntMatch(String eTag) {
            GetOptions options = new GetOptions();
            return options.ifETagDoesntMatch(eTag);
        }
    }
}

