/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.options;

public class CreateContainerOptions
implements Cloneable {
    public static final ImmutableCreateContainerOptions NONE = new ImmutableCreateContainerOptions(new CreateContainerOptions());
    private boolean publicRead;

    public CreateContainerOptions() {
    }

    CreateContainerOptions(boolean publicRead) {
        this.publicRead = publicRead;
    }

    public boolean isPublicRead() {
        return this.publicRead;
    }

    public CreateContainerOptions publicRead() {
        this.publicRead = true;
        return this;
    }

    public CreateContainerOptions clone() {
        return new CreateContainerOptions(this.publicRead);
    }

    public String toString() {
        return "[publicRead=" + this.publicRead + "]";
    }

    public static class ImmutableCreateContainerOptions
    extends CreateContainerOptions {
        private final CreateContainerOptions delegate;

        public ImmutableCreateContainerOptions(CreateContainerOptions delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isPublicRead() {
            return this.delegate.isPublicRead();
        }

        @Override
        public CreateContainerOptions publicRead() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CreateContainerOptions clone() {
            return this.delegate.clone();
        }

        @Override
        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class Builder {
        public static CreateContainerOptions publicRead() {
            CreateContainerOptions options = new CreateContainerOptions();
            return options.publicRead();
        }
    }
}

