/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.options;

import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.s3.domain.ObjectMetadata;

public class AWSS3PutOptions
extends PutOptions {
    private ObjectMetadata.StorageClass storageClass;

    public AWSS3PutOptions() {
        this.storageClass = ObjectMetadata.StorageClass.STANDARD;
    }

    public AWSS3PutOptions(boolean multipart, ObjectMetadata.StorageClass storageClass) {
        super(multipart);
        this.storageClass = storageClass;
    }

    public AWSS3PutOptions storageClass(ObjectMetadata.StorageClass storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    public AWSS3PutOptions clone() {
        return new AWSS3PutOptions(this.isMultipart(), this.storageClass);
    }

    public String toString() {
        return "[multipart=" + this.isMultipart() + " storageClass=" + String.valueOf(this.storageClass) + "]";
    }

    public static class Builder {
        public static AWSS3PutOptions multipart() {
            AWSS3PutOptions options = new AWSS3PutOptions();
            return (AWSS3PutOptions)options.multipart();
        }

        public static AWSS3PutOptions storageClass(ObjectMetadata.StorageClass storageClass) {
            AWSS3PutOptions options = new AWSS3PutOptions();
            return options.storageClass(storageClass);
        }
    }
}

