/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Map;
import javax.inject.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Disk;
import org.jclouds.ovf.DiskSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DiskSectionHandler
extends SectionHandler<DiskSection, DiskSection.Builder> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected Disk.Builder diskBuilder = Disk.builder();

    @Inject
    public DiskSectionHandler(Provider<DiskSection.Builder> builderProvider) {
        super(builderProvider);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Disk")) {
            this.diskBuilder.id((String)attributes.get("diskId"));
            this.diskBuilder.capacity(this.attemptToParse((String)attributes.get("capacity"), "capacity", (String)attributes.get("diskId")));
            this.diskBuilder.parentRef((String)attributes.get("parentRef"));
            this.diskBuilder.fileRef((String)attributes.get("fileRef"));
            if (attributes.containsKey("format")) {
                this.diskBuilder.format(URI.create((String)attributes.get("format")));
            }
            this.diskBuilder.populatedSize(this.attemptToParse((String)attributes.get("populatedSize"), "populatedSize", (String)attributes.get("diskId")));
            this.diskBuilder.capacityAllocationUnits((String)attributes.get("capacityAllocationUnits"));
        }
    }

    private Long attemptToParse(String toParse, String key, String diskId) {
        Long val = null;
        if (toParse != null) {
            try {
                val = Long.valueOf(toParse);
            }
            catch (NumberFormatException e) {
                this.logger.warn("%s for disk %s not a number [%s]", new Object[]{key, diskId, toParse});
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Info")) {
            ((DiskSection.Builder)this.builder).info(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Disk")) {
            try {
                ((DiskSection.Builder)this.builder).disk(this.diskBuilder.build());
            }
            finally {
                this.diskBuilder = Disk.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

