/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.logging.Logger;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.util.Predicates2;

public class ConcurrentOpenSocketFinder
implements OpenSocketFinder {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final SocketOpen socketTester;
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;
    private final ListeningExecutorService userExecutor;
    @Inject(optional=true)
    @Named(value="jclouds.compute.socket-finder-allowed-interfaces")
    private AllowedInterfaces allowedInterfaces = AllowedInterfaces.ALL;

    @Inject
    @VisibleForTesting
    ConcurrentOpenSocketFinder(SocketOpen socketTester, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.socketTester = (SocketOpen)Preconditions.checkNotNull((Object)socketTester, (Object)"socketTester");
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
        this.userExecutor = MoreExecutors.listeningDecorator((ExecutorService)((ExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor")));
    }

    @Override
    public HostAndPort findOpenSocketOnNode(NodeMetadata node, final int port, long timeout, TimeUnit timeUnits) {
        ImmutableSet sockets = ConcurrentOpenSocketFinder.checkNodeHasIps(node, this.allowedInterfaces).transform((Function)new Function<String, HostAndPort>(){

            public HostAndPort apply(String from) {
                return HostAndPort.fromParts((String)from, (int)port);
            }
        }).toSet();
        long period = timeUnits.convert(1L, TimeUnit.SECONDS);
        AtomicReference result = Atomics.newReference();
        Predicate findOrBreak = Predicates.or(this.updateRefOnSocketOpen(result), this.throwISEIfNoLongerRunning(node));
        this.logger.debug(">> blocking on sockets %s for %d %s", new Object[]{sockets, timeout, timeUnits});
        boolean passed = this.retryPredicate(findOrBreak, timeout, period, timeUnits).apply((Object)sockets);
        if (passed) {
            this.logger.debug("<< socket %s opened", new Object[]{result});
            assert (result.get() != null);
            return (HostAndPort)result.get();
        }
        this.logger.warn("<< sockets %s didn't open after %d %s", new Object[]{sockets, timeout, timeUnits});
        throw new NoSuchElementException(String.format("could not connect to any ip address port %d on node %s", port, node));
    }

    @VisibleForTesting
    protected <T> Predicate<T> retryPredicate(Predicate<T> findOrBreak, long timeout, long period, TimeUnit timeUnits) {
        return Predicates2.retry(findOrBreak, (long)timeout, (long)period, (TimeUnit)timeUnits);
    }

    private Predicate<Iterable<HostAndPort>> updateRefOnSocketOpen(final AtomicReference<HostAndPort> reachableSocket) {
        return new Predicate<Iterable<HostAndPort>>(){

            public boolean apply(Iterable<HostAndPort> input) {
                ImmutableList.Builder futures = ImmutableList.builder();
                for (final HostAndPort socket : input) {
                    futures.add((Object)ConcurrentOpenSocketFinder.this.userExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (ConcurrentOpenSocketFinder.this.socketTester.apply((Object)socket)) {
                                    reachableSocket.compareAndSet(null, socket);
                                }
                            }
                            catch (RuntimeException e) {
                                ConcurrentOpenSocketFinder.this.logger.warn((Throwable)e, "Error checking reachability of ip:port %s", new Object[]{socket});
                            }
                        }
                    }));
                }
                ConcurrentOpenSocketFinder.blockOn(futures.build());
                return reachableSocket.get() != null;
            }

            public String toString() {
                return "setAndReturnTrueIfSocketFound()";
            }
        };
    }

    private <T> Predicate<T> throwISEIfNoLongerRunning(final NodeMetadata node) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                if (!ConcurrentOpenSocketFinder.this.nodeRunning.apply((Object)Atomics.newReference((Object)node))) {
                    throw new IllegalStateException(node.getId() + " is no longer running; aborting socket open loop");
                }
                return false;
            }

            public String toString() {
                return "throwISEIfNoLongerRunning(" + node.getId() + ")";
            }
        };
    }

    @VisibleForTesting
    static FluentIterable<String> checkNodeHasIps(NodeMetadata node, AllowedInterfaces allowedInterfaces) {
        ImmutableSet ips;
        ImmutableSet.Builder ipsBuilder = ImmutableSet.builder();
        if (allowedInterfaces.scanPublic) {
            ipsBuilder.addAll(node.getPublicAddresses());
        }
        if (allowedInterfaces.scanPrivate) {
            ipsBuilder.addAll(node.getPrivateAddresses());
        }
        Preconditions.checkState((!(ips = ipsBuilder.build()).isEmpty() ? 1 : 0) != 0, (String)"node does not have IP addresses configured: %s", (Object)node);
        return FluentIterable.from((Iterable)ips);
    }

    private static void blockOn(Iterable<ListenableFuture<?>> immutableList) {
        try {
            Futures.allAsList(immutableList).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Throwables.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    static enum AllowedInterfaces {
        ALL(true, true),
        PUBLIC(true, false),
        PRIVATE(false, true);

        private final boolean scanPublic;
        private final boolean scanPrivate;

        private AllowedInterfaces(boolean scanPublic, boolean scanPrivate) {
            this.scanPublic = scanPublic;
            this.scanPrivate = scanPrivate;
        }
    }
}

