/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.suppliers;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Provider;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.rest.suppliers.ValueLoadedCallback;

@Beta
public class ImageCacheSupplier
implements Supplier<Set<? extends Image>>,
ValueLoadedCallback<Set<? extends Image>> {
    private final Supplier<Set<? extends Image>> liveImageSupplier;
    private final Supplier<Set<? extends Image>> memoizedImageSupplier;
    private final LoadingCache<String, Image> imageCache;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public ImageCacheSupplier(Supplier<Set<? extends Image>> imageSupplier, long sessionIntervalSeconds, AtomicReference<AuthorizationException> authException, final Provider<GetImageStrategy> imageLoader) {
        this.liveImageSupplier = imageSupplier;
        this.memoizedImageSupplier = MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, imageSupplier, (long)sessionIntervalSeconds, (TimeUnit)TimeUnit.SECONDS, (ValueLoadedCallback)this);
        this.imageCache = CacheBuilder.newBuilder().expireAfterWrite(sessionIntervalSeconds, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Image>(){

            public Image load(String key) throws Exception {
                return ((GetImageStrategy)imageLoader.get()).getImage(key);
            }
        });
    }

    public Set<? extends Image> get() {
        this.memoizedImageSupplier.get();
        return ImmutableSet.copyOf(this.imageCache.asMap().values());
    }

    public void valueLoaded(Optional<Set<? extends Image>> value) {
        if (value.isPresent()) {
            this.reset((Set)value.get());
        }
    }

    public void reset(Set<? extends Image> images) {
        this.imageCache.invalidateAll();
        this.imageCache.putAll((Map)Maps.uniqueIndex(images, (Function)new Function<Image, String>(){

            public String apply(Image input) {
                return input.getId();
            }
        }));
    }

    public Set<? extends Image> rebuildCache() {
        Set images = (Set)this.liveImageSupplier.get();
        this.reset(images);
        return images;
    }

    public Optional<? extends Image> get(String id) {
        try {
            return Optional.fromNullable((Object)((Image)this.imageCache.getUnchecked((Object)id)));
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Unexpected error loading image %s", new Object[]{id});
            return Optional.absent();
        }
    }

    public void registerImage(Image image) {
        Preconditions.checkNotNull((Object)image, (Object)"image");
        this.imageCache.put((Object)image.getId(), (Object)image);
    }

    public void removeImage(String imageId) {
        this.imageCache.invalidate(Preconditions.checkNotNull((Object)imageId, (Object)"imageId"));
    }
}

