/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.scriptbuilder.domain.Statement;

public class InitializeRunScriptOnNodeOrPlaceInBadMap
implements Callable<RunScriptOnNode> {
    private final RunScriptOnNode.Factory runScriptOnNodeFactory;
    private final Statement script;
    private final Map<NodeMetadata, Exception> badNodes;
    private final NodeMetadata node;
    private final RunScriptOptions options;

    @Inject
    InitializeRunScriptOnNodeOrPlaceInBadMap(RunScriptOnNode.Factory runScriptOnNodeFactory, @Assisted NodeMetadata node, @Assisted Statement script, @Assisted RunScriptOptions options, @Assisted Map<NodeMetadata, Exception> badNodes) {
        this.runScriptOnNodeFactory = (RunScriptOnNode.Factory)Preconditions.checkNotNull((Object)runScriptOnNodeFactory, (Object)"runScriptOnNodeFactory");
        this.script = (Statement)Preconditions.checkNotNull((Object)script, (Object)"script");
        this.badNodes = (Map)Preconditions.checkNotNull(badNodes, (Object)"badNodes");
        this.node = (NodeMetadata)Preconditions.checkNotNull((Object)node, (Object)"node");
        this.options = (RunScriptOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
    }

    @Override
    public RunScriptOnNode call() throws Exception {
        try {
            return this.runScriptOnNodeFactory.create(this.node, this.script, this.options).init();
        }
        catch (Exception e) {
            this.badNodes.put(this.node, e);
            return null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node", (Object)this.node).add("options", (Object)this.options).toString();
    }

    public static interface Factory {
        public Callable<RunScriptOnNode> create(NodeMetadata var1, Statement var2, RunScriptOptions var3, Map<NodeMetadata, Exception> var4);
    }
}

