/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.domain.internal.NullEqualToIsParentOrIsGrandparentOfCurrentLocation;
import org.jclouds.compute.domain.internal.TemplateImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.compute.suppliers.ImageCacheSupplier;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;

public class TemplateBuilderImpl
implements TemplateBuilder {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final ImageCacheSupplier images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final Supplier<Set<? extends Location>> locations;
    protected final Supplier<Location> defaultLocation;
    protected final Provider<TemplateOptions> optionsProvider;
    protected final Provider<TemplateBuilder> defaultTemplateProvider;
    @VisibleForTesting
    protected Location location;
    @VisibleForTesting
    protected String imageId;
    @VisibleForTesting
    protected String hardwareId;
    @VisibleForTesting
    protected String hypervisor;
    @VisibleForTesting
    protected String imageVersion;
    @VisibleForTesting
    protected OsFamily osFamily;
    @VisibleForTesting
    protected String osVersion;
    @VisibleForTesting
    protected Boolean os64Bit;
    @VisibleForTesting
    protected String osName;
    @VisibleForTesting
    protected String osDescription;
    @VisibleForTesting
    protected String osArch;
    @VisibleForTesting
    protected String imageName;
    @VisibleForTesting
    protected String imageDescription;
    @VisibleForTesting
    protected Predicate<Image> imagePredicate;
    @VisibleForTesting
    protected Function<Iterable<? extends Image>, Image> imageChooser;
    @VisibleForTesting
    protected double minCores;
    @VisibleForTesting
    protected int minRam;
    @VisibleForTesting
    protected double minDisk;
    @VisibleForTesting
    protected boolean biggest;
    @VisibleForTesting
    protected boolean fastest;
    @VisibleForTesting
    protected TemplateOptions options;
    @VisibleForTesting
    protected Boolean forceCacheReload;
    final Predicate<ComputeMetadata> locationPredicate = new NullEqualToIsParentOrIsGrandparentOfCurrentLocation(new Supplier<Location>(){

        public Location get() {
            return TemplateBuilderImpl.this.location;
        }
    });
    private final Predicate<OperatingSystem> osFamilyPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osFamily != null) {
                returnVal = TemplateBuilderImpl.this.osFamily.equals((Object)input.getFamily());
            }
            return returnVal;
        }

        public String toString() {
            return "osFamily(" + String.valueOf((Object)TemplateBuilderImpl.this.osFamily) + ")";
        }
    };
    private final Predicate<OperatingSystem> osNamePredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osName != null) {
                returnVal = input.getName() == null ? false : input.getName().contains(TemplateBuilderImpl.this.osName) || input.getName().matches(TemplateBuilderImpl.this.osName);
            }
            return returnVal;
        }

        public String toString() {
            return "osName(" + TemplateBuilderImpl.this.osName + ")";
        }
    };
    private final Predicate<OperatingSystem> osDescriptionPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osDescription != null) {
                returnVal = input.getDescription() == null ? false : input.getDescription().contains(TemplateBuilderImpl.this.osDescription) || input.getDescription().matches(TemplateBuilderImpl.this.osDescription);
            }
            return returnVal;
        }

        public String toString() {
            return "osDescription(" + TemplateBuilderImpl.this.osDescription + ")";
        }
    };
    private final Predicate<OperatingSystem> osVersionPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osVersion != null) {
                returnVal = input.getVersion() == null ? false : input.getVersion().contains(TemplateBuilderImpl.this.osVersion) || input.getVersion().matches(TemplateBuilderImpl.this.osVersion);
            }
            return returnVal;
        }

        public String toString() {
            return "osVersion(" + TemplateBuilderImpl.this.osVersion + ")";
        }
    };
    private final Predicate<OperatingSystem> os64BitPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.os64Bit != null) {
                if (TemplateBuilderImpl.this.os64Bit.booleanValue()) {
                    return input.is64Bit();
                }
                return !input.is64Bit();
            }
            return returnVal;
        }

        public String toString() {
            return "os64Bit(" + TemplateBuilderImpl.this.os64Bit + ")";
        }
    };
    private final Predicate<OperatingSystem> osArchPredicate = new Predicate<OperatingSystem>(){

        public boolean apply(OperatingSystem input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.osArch != null) {
                returnVal = input.getArch() == null ? false : input.getArch().contains(TemplateBuilderImpl.this.osArch) || input.getArch().matches(TemplateBuilderImpl.this.osArch);
            }
            return returnVal;
        }

        public String toString() {
            return "osArch(" + TemplateBuilderImpl.this.osArch + ")";
        }
    };
    private final Predicate<Image> imageVersionPredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageVersion != null) {
                returnVal = input.getVersion() == null ? false : input.getVersion().contains(TemplateBuilderImpl.this.imageVersion) || input.getVersion().matches(TemplateBuilderImpl.this.imageVersion);
            }
            return returnVal;
        }

        public String toString() {
            return "imageVersion(" + TemplateBuilderImpl.this.imageVersion + ")";
        }
    };
    private final Predicate<Image> imageNamePredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageName != null) {
                returnVal = input.getName() == null ? false : input.getName().equals(TemplateBuilderImpl.this.imageName) || input.getName().contains(TemplateBuilderImpl.this.imageName) || input.getName().matches(TemplateBuilderImpl.this.imageName);
            }
            return returnVal;
        }

        public String toString() {
            return "imageName(" + TemplateBuilderImpl.this.imageName + ")";
        }
    };
    private final Predicate<Image> imageDescriptionPredicate = new Predicate<Image>(){

        public boolean apply(Image input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.imageDescription != null) {
                returnVal = input.getDescription() == null ? false : input.getDescription().equals(TemplateBuilderImpl.this.imageDescription) || input.getDescription().contains(TemplateBuilderImpl.this.imageDescription) || input.getDescription().matches(TemplateBuilderImpl.this.imageDescription);
            }
            return returnVal;
        }

        public String toString() {
            return "imageDescription(" + TemplateBuilderImpl.this.imageDescription + ")";
        }
    };
    private final Predicate<Hardware> hardwareIdPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.hardwareId != null && (returnVal = TemplateBuilderImpl.this.hardwareId.equals(input.getId()))) {
                TemplateBuilderImpl.this.fromHardware(input);
            }
            return returnVal;
        }

        public String toString() {
            return "hardwareId(" + TemplateBuilderImpl.this.hardwareId + ")";
        }
    };
    private final Predicate<Hardware> hypervisorPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            boolean returnVal = true;
            if (TemplateBuilderImpl.this.hypervisor != null) {
                returnVal = input.getHypervisor() == null ? false : input.getHypervisor().contains(TemplateBuilderImpl.this.hypervisor) || input.getHypervisor().matches(TemplateBuilderImpl.this.hypervisor);
            }
            return returnVal;
        }

        public String toString() {
            return "hypervisorMatches(" + TemplateBuilderImpl.this.hypervisor + ")";
        }
    };
    private final Predicate<Hardware> hardwareCoresPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            double cores = ComputeServiceUtils.getCores(input);
            return cores >= TemplateBuilderImpl.this.minCores;
        }

        public String toString() {
            return "minCores(" + TemplateBuilderImpl.this.minCores + ")";
        }
    };
    private final Predicate<Hardware> hardwareDiskPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            return ComputeServiceUtils.getSpace(input) >= TemplateBuilderImpl.this.minDisk;
        }

        public String toString() {
            return "minDisk(" + TemplateBuilderImpl.this.minDisk + ")";
        }
    };
    private final Predicate<Hardware> hardwareRamPredicate = new Predicate<Hardware>(){

        public boolean apply(Hardware input) {
            return input.getRam() >= TemplateBuilderImpl.this.minRam;
        }

        public String toString() {
            return "minRam(" + TemplateBuilderImpl.this.minRam + ")";
        }
    };
    static final Ordering<Hardware> DEFAULT_SIZE_ORDERING = new Ordering<Hardware>(){

        public int compare(Hardware left, Hardware right) {
            return ComparisonChain.start().compare(ComputeServiceUtils.getCores(left), ComputeServiceUtils.getCores(right)).compare(left.getRam(), right.getRam()).compare(ComputeServiceUtils.getSpace(left), ComputeServiceUtils.getSpace(right)).result();
        }
    };
    static final Ordering<Hardware> BY_CORES_ORDERING = new Ordering<Hardware>(){

        public int compare(Hardware left, Hardware right) {
            return Doubles.compare((double)ComputeServiceUtils.getCoresAndSpeed(left), (double)ComputeServiceUtils.getCoresAndSpeed(right));
        }
    };
    static final Ordering<Hardware> NOT_DEPRECATED_ORDERING = new Ordering<Hardware>(){

        public int compare(Hardware left, Hardware right) {
            return ComparisonChain.start().compareTrueFirst(left.isDeprecated(), right.isDeprecated()).result();
        }
    };
    static final Ordering<Image> DEFAULT_IMAGE_ORDERING = new Ordering<Image>(){

        public int compare(Image left, Image right) {
            return ComparisonChain.start().compare((Object)left.getName(), (Object)right.getName(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getVersion(), (Object)right.getVersion(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getDescription(), (Object)right.getDescription(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getName(), (Object)right.getOperatingSystem().getName(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getVersion(), (Object)right.getOperatingSystem().getVersion(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getDescription(), (Object)right.getOperatingSystem().getDescription(), (Comparator)Ordering.natural().nullsLast()).compare((Object)left.getOperatingSystem().getArch(), (Object)right.getOperatingSystem().getArch(), (Comparator)Ordering.natural().nullsLast()).result();
        }
    };
    private static final Function<Image, String> imageToId = new Function<Image, String>(){

        public String apply(Image arg0) {
            return arg0.getId();
        }
    };
    private static final Function<Hardware, String> hardwareToId = new Function<Hardware, String>(){

        public String apply(Hardware arg0) {
            return arg0.getId();
        }
    };

    @Inject
    protected TemplateBuilderImpl(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, Supplier<Location> defaultLocation, @Named(value="DEFAULT") Provider<TemplateOptions> optionsProvider, @Named(value="DEFAULT") Provider<TemplateBuilder> defaultTemplateProvider) {
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        Preconditions.checkArgument((boolean)(images instanceof ImageCacheSupplier), (Object)"an instance of the ImageCacheSupplier is needed");
        this.images = (ImageCacheSupplier)ImageCacheSupplier.class.cast(images);
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
        this.defaultLocation = (Supplier)Preconditions.checkNotNull(defaultLocation, (Object)"defaultLocation");
        this.optionsProvider = (Provider)Preconditions.checkNotNull(optionsProvider, (Object)"optionsProvider");
        this.defaultTemplateProvider = (Provider)Preconditions.checkNotNull(defaultTemplateProvider, (Object)"defaultTemplateProvider");
    }

    static Predicate<Hardware> supportsImagesPredicate(final Iterable<? extends Image> images) {
        return new Predicate<Hardware>(){

            public boolean apply(final Hardware hardware) {
                return Iterables.any((Iterable)images, (Predicate)new Predicate<Image>(){

                    public boolean apply(Image input) {
                        return hardware.supportsImage().apply((Object)input);
                    }

                    public String toString() {
                        return "hardware(" + String.valueOf(hardware) + ").supportsImage()";
                    }
                });
            }
        };
    }

    private Predicate<Hardware> buildHardwarePredicate() {
        ArrayList predicates = Lists.newArrayList();
        if (this.location != null) {
            predicates.add(new Predicate<Hardware>(){

                public boolean apply(Hardware input) {
                    return TemplateBuilderImpl.this.locationPredicate.apply((Object)input);
                }

                public String toString() {
                    return TemplateBuilderImpl.this.locationPredicate.toString();
                }
            });
        }
        if (this.hypervisor != null) {
            predicates.add(this.hypervisorPredicate);
        }
        predicates.add(this.hardwareCoresPredicate);
        predicates.add(this.hardwareRamPredicate);
        predicates.add(this.hardwareDiskPredicate);
        Predicate hardwarePredicate = predicates.size() == 1 ? (Predicate)Iterables.get((Iterable)predicates, (int)0) : Predicates.and((Iterable)predicates);
        return hardwarePredicate;
    }

    @VisibleForTesting
    final Function<Iterable<? extends Image>, Image> imageChooserFromOrdering(final Ordering<Image> ordering) {
        return new Function<Iterable<? extends Image>, Image>(){

            public Image apply(Iterable<? extends Image> input) {
                List<? extends Image> maxImages = TemplateBuilderImpl.multiMax(ordering, input);
                if (TemplateBuilderImpl.this.logger.isTraceEnabled()) {
                    TemplateBuilderImpl.this.logger.trace("<<   best images(%s)", new Object[]{Iterables.transform(maxImages, imageToId)});
                }
                return maxImages.get(maxImages.size() - 1);
            }
        };
    }

    @VisibleForTesting
    Function<Iterable<? extends Image>, Image> defaultImageChooser() {
        return this.imageChooserFromOrdering(DEFAULT_IMAGE_ORDERING);
    }

    @Override
    public TemplateBuilder fromTemplate(Template template) {
        this.location = template.getLocation();
        this.fromHardware(template.getHardware());
        this.fromImage(template.getImage());
        this.options(template.getOptions());
        return this;
    }

    @Override
    public TemplateBuilder fromHardware(Hardware hardware) {
        if (this.currentLocationWiderThan(hardware.getLocation())) {
            this.location = hardware.getLocation();
        }
        this.minCores = ComputeServiceUtils.getCores(hardware);
        this.minRam = hardware.getRam();
        this.minDisk = ComputeServiceUtils.getSpace(hardware);
        this.hypervisor = hardware.getHypervisor();
        return this;
    }

    private boolean currentLocationWiderThan(Location location) {
        return this.location == null || location != null && this.location.getScope().compareTo((Enum)location.getScope()) < 0;
    }

    @Override
    public TemplateBuilder fromImage(Image image) {
        if (this.currentLocationWiderThan(image.getLocation())) {
            this.location = image.getLocation();
        }
        if (image.getOperatingSystem().getFamily() != null) {
            this.osFamily = image.getOperatingSystem().getFamily();
        }
        if (image.getName() != null) {
            this.imageName = image.getName();
        }
        if (image.getDescription() != null) {
            this.imageDescription = String.format("^%s$", Pattern.quote(image.getDescription()));
        }
        if (image.getOperatingSystem().getName() != null) {
            this.osName = image.getOperatingSystem().getName();
        }
        if (image.getOperatingSystem().getDescription() != null) {
            this.osDescription = image.getOperatingSystem().getDescription();
        }
        if (image.getVersion() != null) {
            this.imageVersion = String.format("^%s$", Pattern.quote(image.getVersion()));
        }
        if (image.getOperatingSystem().getVersion() != null) {
            this.osVersion = image.getOperatingSystem().getVersion();
        }
        this.os64Bit = image.getOperatingSystem().is64Bit();
        if (image.getOperatingSystem().getArch() != null) {
            this.osArch = image.getOperatingSystem().getArch();
        }
        return this;
    }

    @Override
    public TemplateBuilder smallest() {
        this.biggest = false;
        return this;
    }

    @Override
    public TemplateBuilder biggest() {
        this.biggest = true;
        return this;
    }

    @Override
    public TemplateBuilder fastest() {
        this.fastest = true;
        return this;
    }

    @Override
    public TemplateBuilder locationId(final String locationId) {
        Set locations = (Set)this.locations.get();
        try {
            this.location = (Location)Iterables.find((Iterable)locations, (Predicate)new Predicate<Location>(){

                public boolean apply(Location input) {
                    return input.getId().equals(locationId);
                }

                public String toString() {
                    return "locationId(" + locationId + ")";
                }
            });
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("location id %s not found in: %s", locationId, locations));
        }
        return this;
    }

    @Override
    public TemplateBuilder osFamily(OsFamily os) {
        this.osFamily = os;
        return this;
    }

    @Override
    public Template build() {
        if (this.nothingChangedExceptOptions()) {
            TemplateBuilder defaultTemplate = (TemplateBuilder)this.defaultTemplateProvider.get();
            if (this.options != null) {
                defaultTemplate.options(this.options);
            }
            return defaultTemplate.build();
        }
        if (this.options == null) {
            this.options = (TemplateOptions)this.optionsProvider.get();
        }
        this.logger.debug(">> searching params(%s)", new Object[]{this});
        Set<? extends Image> images = this.getImages();
        Preconditions.checkState((!images.isEmpty() ? 1 : 0) != 0, (Object)"no images present!");
        Set hardwaresToSearch = (Set)this.hardwares.get();
        Preconditions.checkState((!hardwaresToSearch.isEmpty() ? 1 : 0) != 0, (Object)"no hardware profiles present!");
        Image image = null;
        if (this.imageId != null && this.currentLocationWiderThan((image = this.loadImageWithId(images)).getLocation())) {
            this.location = image.getLocation();
        }
        Hardware hardware = null;
        if (this.hardwareId != null && this.currentLocationWiderThan((hardware = this.findHardwareWithId(hardwaresToSearch)).getLocation())) {
            this.location = hardware.getLocation();
        }
        if (this.location == null) {
            this.location = (Location)this.defaultLocation.get();
        }
        if (image == null) {
            Iterable<? extends Image> supportedImages = this.findSupportedImages(images);
            if (hardware == null) {
                hardware = this.resolveHardware(hardwaresToSearch, supportedImages);
            }
            image = this.resolveImage(hardware, supportedImages);
        } else if (hardware == null) {
            hardware = this.resolveHardware(hardwaresToSearch, (Iterable<? extends Image>)ImmutableSet.of((Object)image));
        }
        this.logger.debug("<<   matched image(%s) hardware(%s) location(%s)", new Object[]{image.getId(), hardware.getId(), this.location.getId()});
        return new TemplateImpl(image, hardware, this.location, this.options);
    }

    private Iterable<? extends Image> findSupportedImages(Set<? extends Image> images) {
        Predicate<Image> imagePredicate = this.buildImagePredicate();
        Iterable supportedImages = Iterables.filter(images, imagePredicate);
        if (Iterables.size((Iterable)supportedImages) == 0) {
            throw this.throwNoSuchElementExceptionAfterLoggingImageIds(String.format("no image matched predicate: %s", imagePredicate), images);
        }
        return supportedImages;
    }

    private Image loadImageWithId(Iterable<? extends Image> images) {
        Optional<? extends Image> image = Iterables.tryFind(images, ImagePredicates.idEquals(this.imageId));
        if (!image.isPresent() && !(image = this.images.get(this.imageId)).isPresent()) {
            throw this.throwNoSuchElementExceptionAfterLoggingImageIds(String.format("imageId(%s) not found", this.imageId), images);
        }
        this.fromImage((Image)image.get());
        return (Image)image.get();
    }

    protected Hardware findHardwareWithId(Set<? extends Hardware> hardwaresToSearch) {
        Hardware hardware = (Hardware)Iterables.tryFind(hardwaresToSearch, this.hardwareIdPredicate).orNull();
        if (hardware == null) {
            throw this.throwNoSuchElementExceptionAfterLoggingHardwareIds(String.format("%s not found", this.hardwareIdPredicate), hardwaresToSearch);
        }
        return hardware;
    }

    protected NoSuchElementException throwNoSuchElementExceptionAfterLoggingImageIds(String message, Iterable<? extends Image> images) {
        NoSuchElementException exception = new NoSuchElementException(message);
        if (this.logger.isTraceEnabled()) {
            this.logger.warn((Throwable)exception, "image ids that didn't match: %s", new Object[]{Iterables.transform(images, imageToId)});
        }
        throw exception;
    }

    protected NoSuchElementException throwNoSuchElementExceptionAfterLoggingHardwareIds(String message, Iterable<? extends Hardware> hardwares) {
        NoSuchElementException exception = new NoSuchElementException(message);
        if (this.logger.isTraceEnabled()) {
            this.logger.warn((Throwable)exception, "hardware ids that didn't match: %s", new Object[]{Iterables.transform(hardwares, hardwareToId)});
        }
        throw exception;
    }

    protected Hardware resolveHardware(Set<? extends Hardware> hardwarel, Iterable<? extends Image> images) {
        Hardware hardware;
        Predicate supportsImagePredicate;
        Ordering<Hardware> hardwareOrdering = this.hardwareSorter();
        Iterable supportsImagePredicates = Iterables.transform(hardwarel, (Function)new Function<Hardware, Predicate<Image>>(){

            public Predicate<Image> apply(Hardware input) {
                return input.supportsImage();
            }
        });
        Predicate predicate = supportsImagePredicate = Iterables.size((Iterable)supportsImagePredicates) == 1 ? (Predicate)Iterables.getOnlyElement((Iterable)supportsImagePredicates) : Predicates.or((Iterable)supportsImagePredicates);
        if (!Iterables.any(images, (Predicate)supportsImagePredicate)) {
            String message = String.format("no hardware profiles support images matching params: %s", supportsImagePredicate);
            throw this.throwNoSuchElementExceptionAfterLoggingHardwareIds(message, hardwarel);
        }
        Iterable hardwareCompatibleWithOurImages = Iterables.filter(hardwarel, TemplateBuilderImpl.supportsImagesPredicate(images));
        Predicate<Hardware> hardwarePredicate = this.buildHardwarePredicate();
        try {
            hardware = (Hardware)hardwareOrdering.max(Iterables.filter((Iterable)hardwareCompatibleWithOurImages, hardwarePredicate));
        }
        catch (NoSuchElementException exception) {
            String message = String.format("no hardware profiles match params: %s", hardwarePredicate);
            throw this.throwNoSuchElementExceptionAfterLoggingHardwareIds(message, hardwareCompatibleWithOurImages);
        }
        this.logger.trace("<<   matched hardware(%s)", new Object[]{hardware.getId()});
        return hardware;
    }

    protected Function<Iterable<? extends Image>, Image> imageChooser() {
        if (this.imageChooser != null) {
            return this.imageChooser;
        }
        return this.defaultImageChooser();
    }

    protected Ordering<Hardware> hardwareSorter() {
        Ordering hardwareOrdering = DEFAULT_SIZE_ORDERING;
        if (!this.biggest) {
            hardwareOrdering = hardwareOrdering.reverse();
        }
        if (this.fastest) {
            hardwareOrdering = Ordering.compound((Iterable)ImmutableList.of(BY_CORES_ORDERING, (Object)hardwareOrdering));
        }
        hardwareOrdering = Ordering.compound((Iterable)ImmutableList.of(NOT_DEPRECATED_ORDERING, (Object)hardwareOrdering));
        return hardwareOrdering;
    }

    protected Image resolveImage(final Hardware hardware, Iterable<? extends Image> supportedImages) {
        Predicate<Image> imagePredicate = new Predicate<Image>(){

            public boolean apply(Image arg0) {
                return hardware.supportsImage().apply((Object)arg0);
            }

            public String toString() {
                return "hardware(" + String.valueOf(hardware) + ").supportsImage()";
            }
        };
        try {
            Iterable matchingImages = Iterables.filter(supportedImages, (Predicate)imagePredicate);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("<<   matched images(%s)", new Object[]{Iterables.transform((Iterable)matchingImages, imageToId)});
            }
            return (Image)this.imageChooser().apply((Object)matchingImages);
        }
        catch (NoSuchElementException exception) {
            throw this.throwNoSuchElementExceptionAfterLoggingImageIds(String.format("no image matched params: %s", this.toString()), supportedImages);
        }
    }

    @VisibleForTesting
    static <T, E extends T> List<E> multiMax(Comparator<T> ordering, Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        ArrayList maxes = Lists.newArrayList((Object[])new Object[]{iterator.next()});
        Object maxSoFar = maxes.get(0);
        while (iterator.hasNext()) {
            E current = iterator.next();
            int comparison = ordering.compare(maxSoFar, current);
            if (comparison == 0) {
                maxes.add(current);
                continue;
            }
            if (comparison >= 0) continue;
            maxes = Lists.newArrayList((Object[])new Object[]{current});
            maxSoFar = current;
        }
        return maxes;
    }

    protected Set<? extends Image> getImages() {
        return this.forceCacheReload != null && this.forceCacheReload != false ? this.images.rebuildCache() : this.images.get();
    }

    private Predicate<Image> buildImagePredicate() {
        ArrayList predicates = Lists.newArrayList();
        if (this.location != null) {
            predicates.add(new Predicate<Image>(){

                public boolean apply(Image input) {
                    return TemplateBuilderImpl.this.locationPredicate.apply((Object)input);
                }

                public String toString() {
                    return TemplateBuilderImpl.this.locationPredicate.toString();
                }
            });
        }
        final ArrayList osPredicates = Lists.newArrayList();
        if (this.osFamily != null) {
            osPredicates.add(this.osFamilyPredicate);
        }
        if (this.osName != null) {
            osPredicates.add(this.osNamePredicate);
        }
        if (this.osDescription != null) {
            osPredicates.add(this.osDescriptionPredicate);
        }
        if (this.osVersion != null) {
            osPredicates.add(this.osVersionPredicate);
        }
        if (this.os64Bit != null) {
            osPredicates.add(this.os64BitPredicate);
        }
        if (this.osArch != null) {
            osPredicates.add(this.osArchPredicate);
        }
        if (!osPredicates.isEmpty()) {
            predicates.add(new Predicate<Image>(){

                public boolean apply(Image input) {
                    return Predicates.and((Iterable)osPredicates).apply((Object)input.getOperatingSystem());
                }

                public String toString() {
                    return Predicates.and((Iterable)osPredicates).toString();
                }
            });
        }
        if (this.imageVersion != null) {
            predicates.add(this.imageVersionPredicate);
        }
        if (this.imageName != null) {
            predicates.add(this.imageNamePredicate);
        }
        if (this.imageDescription != null) {
            predicates.add(this.imageDescriptionPredicate);
        }
        if (this.imagePredicate != null) {
            predicates.add(this.imagePredicate);
        }
        Predicate imagePredicate = predicates.size() == 1 ? (Predicate)Iterables.get((Iterable)predicates, (int)0) : Predicates.and((Iterable)predicates);
        return imagePredicate;
    }

    @Override
    public TemplateBuilder imageId(String imageId) {
        this.imageId = imageId;
        this.imageName = null;
        this.imageDescription = null;
        this.imagePredicate = null;
        this.imageVersion = null;
        this.osFamily = null;
        this.osName = null;
        this.osDescription = null;
        this.osVersion = null;
        this.os64Bit = null;
        this.osArch = null;
        return this;
    }

    @Override
    public TemplateBuilder imageNameMatches(String nameRegex) {
        this.imageName = nameRegex;
        return this;
    }

    @Override
    public TemplateBuilder imageDescriptionMatches(String descriptionRegex) {
        this.imageDescription = descriptionRegex;
        return this;
    }

    @Override
    public TemplateBuilder imageMatches(Predicate<Image> condition) {
        this.imagePredicate = condition;
        return this;
    }

    @Override
    public TemplateBuilderImpl imageChooser(Function<Iterable<? extends Image>, Image> imageChooser) {
        this.imageChooser = imageChooser;
        return this;
    }

    @Override
    public TemplateBuilder imageVersionMatches(String imageVersionRegex) {
        this.imageVersion = imageVersionRegex;
        return this;
    }

    @Override
    public TemplateBuilder osVersionMatches(String osVersionRegex) {
        this.osVersion = osVersionRegex;
        return this;
    }

    @Override
    public TemplateBuilder osArchMatches(String osArchitectureRegex) {
        this.osArch = osArchitectureRegex;
        return this;
    }

    @Override
    public TemplateBuilder minCores(double minCores) {
        this.minCores = minCores;
        return this;
    }

    @Override
    public TemplateBuilder minRam(int megabytes) {
        this.minRam = megabytes;
        return this;
    }

    @Override
    public TemplateBuilder minDisk(double gigabytes) {
        this.minDisk = gigabytes;
        return this;
    }

    @Override
    public TemplateBuilder osNameMatches(String osNameRegex) {
        this.osName = osNameRegex;
        return this;
    }

    @Override
    public TemplateBuilder osDescriptionMatches(String osDescriptionRegex) {
        this.osDescription = osDescriptionRegex;
        return this;
    }

    @Override
    public TemplateBuilder hardwareId(String hardwareId) {
        this.hardwareId = hardwareId;
        this.hypervisor = null;
        return this;
    }

    @Override
    public TemplateBuilder hypervisorMatches(String hypervisor) {
        this.hypervisor = hypervisor;
        return this;
    }

    @Override
    public TemplateBuilder options(TemplateOptions options) {
        this.options = (TemplateOptions)this.optionsProvider.get();
        ((TemplateOptions)Preconditions.checkNotNull((Object)options, (Object)"options")).copyTo(this.options);
        return this;
    }

    @VisibleForTesting
    boolean nothingChangedExceptOptions() {
        return this.osFamily == null && this.location == null && this.imageId == null && this.hardwareId == null && this.hypervisor == null && this.osName == null && this.imagePredicate == null && this.imageChooser == null && this.osDescription == null && this.imageVersion == null && this.osVersion == null && this.osArch == null && this.os64Bit == null && this.imageName == null && this.imageDescription == null && this.minCores == 0.0 && this.minRam == 0 && this.minDisk == 0.0 && !this.biggest && !this.fastest;
    }

    @Override
    public TemplateBuilder any() {
        return (TemplateBuilder)this.defaultTemplateProvider.get();
    }

    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper((String)"").omitNullValues();
        if (this.biggest) {
            toString.add("biggest", this.biggest);
        }
        if (this.fastest) {
            toString.add("fastest", this.fastest);
        }
        toString.add("imageName", (Object)this.imageName);
        toString.add("imageDescription", (Object)this.imageDescription);
        toString.add("imageId", (Object)this.imageId);
        toString.add("imagePredicate", this.imagePredicate);
        toString.add("imageChooser", this.imageChooser);
        toString.add("imageVersion", (Object)this.imageVersion);
        if (this.location != null) {
            toString.add("locationId", (Object)this.location.getId());
        }
        if (this.minCores > 0.0) {
            toString.add("minCores", this.minCores);
        }
        if (this.minRam > 0) {
            toString.add("minRam", this.minRam);
        }
        if (this.minRam > 0) {
            toString.add("minRam", this.minRam);
        }
        if (this.minDisk > 0.0) {
            toString.add("minDisk", this.minDisk);
        }
        toString.add("osFamily", (Object)this.osFamily);
        toString.add("osName", (Object)this.osName);
        toString.add("osDescription", (Object)this.osDescription);
        toString.add("osVersion", (Object)this.osVersion);
        toString.add("osArch", (Object)this.osArch);
        toString.add("os64Bit", (Object)this.os64Bit);
        toString.add("hardwareId", (Object)this.hardwareId);
        toString.add("hypervisor", (Object)this.hypervisor);
        toString.add("forceCacheReload", (Object)this.forceCacheReload);
        return toString;
    }

    @Override
    public TemplateBuilder os64Bit(boolean is64Bit) {
        this.os64Bit = is64Bit;
        return this;
    }

    @Override
    public TemplateBuilder from(TemplateBuilderSpec spec) {
        return spec.copyTo(this, this.options != null ? this.options : (this.options = (TemplateOptions)this.optionsProvider.get()));
    }

    @Override
    public TemplateBuilder from(String spec) {
        return this.from(TemplateBuilderSpec.parse(spec));
    }

    @Override
    public TemplateBuilder forceCacheReload() {
        this.forceCacheReload = true;
        return this;
    }
}

