/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.config;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.inject.ImplementedBy;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Map;
import org.jclouds.compute.functions.Sha512Crypt;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.ssh.SshKeys;

@ImplementedBy(value=Default.class)
public interface AdminAccessConfiguration
extends AdminAccess.Configuration {

    @Singleton
    public static class Default
    implements AdminAccessConfiguration {
        private final Supplier<String> defaultAdminUsername = Suppliers.ofInstance((Object)System.getProperty("user.name"));
        private final Supplier<Map<String, String>> defaultAdminSshKeys = new Supplier<Map<String, String>>(){

            public Map<String, String> get() {
                try {
                    return ImmutableMap.of((Object)"public", (Object)Files.toString((File)new File(System.getProperty("user.home") + "/.ssh/id_rsa.pub"), (Charset)Charsets.UTF_8), (Object)"private", (Object)Files.toString((File)new File(System.getProperty("user.home") + "/.ssh/id_rsa"), (Charset)Charsets.UTF_8));
                }
                catch (IOException e) {
                    return SshKeys.generate();
                }
            }
        };
        private final Function<String, String> cryptFunction = Sha512Crypt.function();

        public Supplier<String> defaultAdminUsername() {
            return this.defaultAdminUsername;
        }

        public Supplier<Map<String, String>> defaultAdminSshKeys() {
            return this.defaultAdminSshKeys;
        }

        public Supplier<String> passwordGenerator() {
            return PasswordGenerator.INSTANCE;
        }

        public Function<String, String> cryptFunction() {
            return this.cryptFunction;
        }

        static enum PasswordGenerator implements Supplier<String>
        {
            INSTANCE;

            public static final int MIN_LENGTH = 10;
            protected static final SecureRandom r;
            public static final char[] goodChar;

            public String get() {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 10; ++i) {
                    sb.append(goodChar[r.nextInt(goodChar.length)]);
                }
                return sb.toString();
            }

            static {
                r = new SecureRandom();
                goodChar = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9', '+', '-', '@'};
            }
        }
    }
}

