/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.extensions;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v2_0.KeystoneFallbacks;
import org.jclouds.openstack.neutron.v2.domain.CreateFirewall;
import org.jclouds.openstack.neutron.v2.domain.CreateFirewallPolicy;
import org.jclouds.openstack.neutron.v2.domain.CreateFirewallRule;
import org.jclouds.openstack.neutron.v2.domain.Firewall;
import org.jclouds.openstack.neutron.v2.domain.FirewallPolicy;
import org.jclouds.openstack.neutron.v2.domain.FirewallRule;
import org.jclouds.openstack.neutron.v2.domain.UpdateFirewall;
import org.jclouds.openstack.neutron.v2.domain.UpdateFirewallPolicy;
import org.jclouds.openstack.neutron.v2.domain.UpdateFirewallRule;
import org.jclouds.openstack.neutron.v2.functions.FirewallPolicyToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.FirewallRuleToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.FirewallToPagedIterable;
import org.jclouds.openstack.neutron.v2.functions.ParseFirewallPolicies;
import org.jclouds.openstack.neutron.v2.functions.ParseFirewallRules;
import org.jclouds.openstack.neutron.v2.functions.ParseFirewalls;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/fw")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Extension(of="network", namespace="http://wiki.openstack.org/Neutron/FWaaS/API_1.0", name="Firewall service", alias="fwaas")
@Beta
public interface FWaaSApi {
    @Named(value="fw:list")
    @GET
    @Transform(value=FirewallToPagedIterable.class)
    @ResponseParser(value=ParseFirewalls.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @Path(value="/firewalls")
    public PagedIterable<Firewall> list();

    @Named(value="firewall:list")
    @GET
    @ResponseParser(value=ParseFirewalls.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/firewalls")
    public PaginatedCollection<Firewall> list(PaginationOptions var1);

    @Named(value="firewall:get")
    @GET
    @Path(value="/firewalls/{id}")
    @SelectJson(value={"firewall"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Firewall get(@PathParam(value="id") String var1);

    @Named(value="firewall:create")
    @POST
    @SelectJson(value={"firewall"})
    @Path(value="/firewalls")
    public Firewall create(@WrapWith(value="firewall") CreateFirewall var1);

    @Named(value="firewall:update")
    @PUT
    @Path(value="/firewalls/{id}")
    @SelectJson(value={"firewall"})
    public Firewall update(@PathParam(value="id") String var1, @WrapWith(value="firewall") UpdateFirewall var2);

    @Named(value="firewall:delete")
    @DELETE
    @Path(value="/firewalls/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="firewall:createPolicy")
    @POST
    @SelectJson(value={"firewall_policy"})
    @Path(value="/firewall_policies")
    public FirewallPolicy createFirewallPolicy(@WrapWith(value="firewall_policy") CreateFirewallPolicy var1);

    @Named(value="firewall:listPolicies")
    @GET
    @Transform(value=FirewallPolicyToPagedIterable.class)
    @ResponseParser(value=ParseFirewallPolicies.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @Path(value="/firewall_policies")
    public PagedIterable<FirewallPolicy> listFirewallPolicies();

    @Named(value="firewall:listPolicies")
    @GET
    @ResponseParser(value=ParseFirewallPolicies.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/firewall_policies")
    public PaginatedCollection<FirewallPolicy> listFirewallPolicies(PaginationOptions var1);

    @Named(value="firewall:getPolicy")
    @GET
    @SelectJson(value={"firewall_policy"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Path(value="/firewall_policies/{id}")
    public FirewallPolicy getFirewallPolicy(@PathParam(value="id") String var1);

    @Named(value="firewall:updatePolicy")
    @PUT
    @SelectJson(value={"firewall_policy"})
    @Path(value="/firewall_policies/{id}")
    public FirewallPolicy updateFirewallPolicy(@PathParam(value="id") String var1, @WrapWith(value="firewall_policy") UpdateFirewallPolicy var2);

    @Named(value="firewall:deletePolicy")
    @DELETE
    @Path(value="/firewall_policies/{id}")
    public boolean deleteFirewallPolicy(@PathParam(value="id") String var1);

    @Named(value="firewall:createFirewallRule")
    @POST
    @SelectJson(value={"firewall_rule"})
    @Path(value="/firewall_rules")
    public FirewallRule createFirewallRule(@WrapWith(value="firewall_rule") CreateFirewallRule var1);

    @Named(value="firewall:listFirewallRules")
    @GET
    @Transform(value=FirewallRuleToPagedIterable.class)
    @ResponseParser(value=ParseFirewallRules.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    @Path(value="/firewall_rules")
    public PagedIterable<FirewallRule> listFirewallRules();

    @Named(value="firewall:listFirewallRules")
    @GET
    @ResponseParser(value=ParseFirewallRules.class)
    @Fallback(value=KeystoneFallbacks.EmptyPaginatedCollectionOnNotFoundOr404.class)
    @Path(value="/firewall_rules")
    public PaginatedCollection<FirewallRule> listFirewallRules(PaginationOptions var1);

    @Named(value="firewall:getFirewallRule")
    @GET
    @Path(value="/firewall_rules/{id}")
    @SelectJson(value={"firewall_rule"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public FirewallRule getFirewallRule(@PathParam(value="id") String var1);

    @Named(value="firewall:updateFirewallRule")
    @PUT
    @Path(value="/firewall_rules/{id}")
    @SelectJson(value={"firewall_rule"})
    public FirewallRule updateFirewallRule(@PathParam(value="id") String var1, @WrapWith(value="firewall_rule") UpdateFirewallRule var2);

    @Named(value="firewall:deleteFirewallRule")
    @DELETE
    @Path(value="/firewall_rules/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteFirewallRule(@PathParam(value="id") String var1);

    @Named(value="firewall:insertFirewallRuleToPolicy")
    @PUT
    @Path(value="/firewall_policies/{id}/insert_rule")
    public FirewallPolicy insertFirewallRuleToPolicy(@PathParam(value="id") String var1, @WrapWith(value="firewall_rule_id") String var2);

    @Named(value="firewall:removeFirewallRuleFromPolicy")
    @DELETE
    @Path(value="/firewall_policies/{id}/remove_rule")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public FirewallPolicy removeFirewallRuleFromPolicy(@PathParam(value="id") String var1, @WrapWith(value="firewall_rule_id") String var2);
}

