/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.neutron.v2.domain.NetworkSegment;
import org.jclouds.openstack.neutron.v2.domain.NetworkStatus;
import org.jclouds.openstack.neutron.v2.domain.NetworkType;

public class Network {
    private String id;
    private NetworkStatus status;
    private ImmutableSet<String> subnets;
    private String name;
    @Named(value="admin_state_up")
    private Boolean adminStateUp;
    private Boolean shared;
    @Named(value="tenant_id")
    private String tenantId;
    @Named(value="availability_zone")
    private String availabilityZone;
    @Named(value="provider:network_type")
    private NetworkType networkType;
    @Named(value="provider:physical_network")
    private String physicalNetworkName;
    @Named(value="provider:segmentation_id")
    private Integer segmentationId;
    @Named(value="router:external")
    private Boolean external;
    @Named(value="port_security_enabled")
    private Boolean portSecurity;
    @Named(value="n1kv:profile_id")
    private String profileId;
    @Named(value="n1kv:multicast_ip")
    private String multicastIp;
    @Named(value="n1kv:segment_add")
    private String segmentAdd;
    @Named(value="n1kv:segment_del")
    private String segmentDel;
    @Named(value="n1kv:member_segments")
    private String memberSegments;
    private ImmutableSet<NetworkSegment> segments;
    @Named(value="flavor:network")
    private String networkFlavor;

    @ConstructorProperties(value={"id", "status", "subnets", "name", "admin_state_up", "shared", "tenant_id", "availability_zone", "provider:network_type", "provider:physical_network", "provider:segmentation_id", "router:external", "port_security_enabled", "n1kv:profile_id", "n1kv:multicast_ip", "n1kv:segment_add", "n1kv:segment_del", "n1kv:member_segments", "segments", "flavor:network"})
    private Network(String id, NetworkStatus status, ImmutableSet<String> subnets, String name, Boolean adminStateUp, Boolean shared, String tenantId, String availabilityZone, NetworkType networkType, String physicalNetworkName, Integer segmentationId, Boolean external, Boolean portSecurity, String profileId, String multicastIp, String segmentAdd, String segmentDel, String memberSegments, ImmutableSet<NetworkSegment> segments, String networkFlavor) {
        this.id = id;
        this.status = status;
        this.subnets = subnets;
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.shared = shared;
        this.tenantId = tenantId;
        this.availabilityZone = availabilityZone;
        this.networkType = networkType;
        this.physicalNetworkName = physicalNetworkName;
        this.segmentationId = segmentationId;
        this.external = external;
        this.portSecurity = portSecurity;
        this.profileId = profileId;
        this.multicastIp = multicastIp;
        this.segmentAdd = segmentAdd;
        this.segmentDel = segmentDel;
        this.memberSegments = memberSegments;
        this.segments = segments;
        this.networkFlavor = networkFlavor;
    }

    private Network() {
    }

    private Network(Network network) {
        this(network.id, network.status, network.subnets, network.name, network.adminStateUp, network.shared, network.tenantId, network.availabilityZone, network.networkType, network.physicalNetworkName, network.segmentationId, network.external, network.portSecurity, network.profileId, network.multicastIp, network.segmentAdd, network.segmentDel, network.memberSegments, network.segments, network.networkFlavor);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public NetworkStatus getStatus() {
        return this.status;
    }

    @Nullable
    public ImmutableSet<String> getSubnets() {
        return this.subnets;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    @Nullable
    public Boolean getShared() {
        return this.shared;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    @Nullable
    public NetworkType getNetworkType() {
        return this.networkType;
    }

    @Nullable
    public String getPhysicalNetworkName() {
        return this.physicalNetworkName;
    }

    @Nullable
    public Integer getSegmentationId() {
        return this.segmentationId;
    }

    @Nullable
    public Boolean getExternal() {
        return this.external;
    }

    @Nullable
    public Boolean getPortSecurity() {
        return this.portSecurity;
    }

    @Nullable
    public String getProfileId() {
        return this.profileId;
    }

    @Nullable
    public String getMulticastIp() {
        return this.multicastIp;
    }

    @Nullable
    public String getSegmentAdd() {
        return this.segmentAdd;
    }

    @Nullable
    public String getSegmentDel() {
        return this.segmentDel;
    }

    @Nullable
    public String getMemberSegments() {
        return this.memberSegments;
    }

    @Nullable
    public ImmutableSet<NetworkSegment> getSegments() {
        return this.segments;
    }

    @Nullable
    public String getNetworkFlavor() {
        return this.networkFlavor;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.status, this.subnets, this.name, this.adminStateUp, this.shared, this.tenantId, this.availabilityZone, this.networkType, this.physicalNetworkName, this.segmentationId, this.external, this.portSecurity, this.profileId, this.multicastIp, this.segmentAdd, this.segmentDel, this.memberSegments, this.segments, this.networkFlavor});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Network that = (Network)Network.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal(this.subnets, that.subnets) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)this.shared, (Object)that.shared) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.availabilityZone, (Object)that.availabilityZone) && Objects.equal((Object)((Object)this.networkType), (Object)((Object)that.networkType)) && Objects.equal((Object)this.physicalNetworkName, (Object)that.physicalNetworkName) && Objects.equal((Object)this.segmentationId, (Object)that.segmentationId) && Objects.equal((Object)this.external, (Object)that.external) && Objects.equal((Object)this.portSecurity, (Object)that.portSecurity) && Objects.equal((Object)this.profileId, (Object)that.profileId) && Objects.equal((Object)this.multicastIp, (Object)that.multicastIp) && Objects.equal((Object)this.segmentAdd, (Object)that.segmentAdd) && Objects.equal((Object)this.segmentDel, (Object)that.segmentDel) && Objects.equal((Object)this.memberSegments, (Object)that.memberSegments) && Objects.equal(this.segments, that.segments) && Objects.equal((Object)this.networkFlavor, (Object)that.networkFlavor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("status", (Object)this.status).add("subnets", this.subnets).add("name", (Object)this.name).add("adminStateUp", (Object)this.adminStateUp).add("shared", (Object)this.shared).add("tenantId", (Object)this.tenantId).add("availabilityZone", (Object)this.availabilityZone).add("networkType", (Object)this.networkType).add("physicalNetworkName", (Object)this.physicalNetworkName).add("segmentationId", (Object)this.segmentationId).add("external", (Object)this.external).add("portSecurity", (Object)this.portSecurity).add("profileId", (Object)this.profileId).add("multicastIp", (Object)this.multicastIp).add("segmentAdd", (Object)this.segmentAdd).add("segmentDel", (Object)this.segmentDel).add("memberSegments", (Object)this.memberSegments).add("segments", this.segments).add("networkFlavor", (Object)this.networkFlavor).toString();
    }

    public static CreateBuilder createBuilder(String name) {
        return new CreateBuilder(name);
    }

    public static UpdateBuilder updateBuilder() {
        return new UpdateBuilder();
    }

    public static class CreateBuilder
    extends Builder<CreateBuilder> {
        private CreateBuilder(String name) {
            this.network.name = name;
        }

        public CreateNetwork build() {
            return new CreateNetwork(this.network);
        }

        @Override
        protected CreateBuilder self() {
            return this;
        }
    }

    public static class UpdateBuilder
    extends Builder<UpdateBuilder> {
        private UpdateBuilder() {
        }

        public UpdateNetwork build() {
            return new UpdateNetwork(this.network);
        }

        @Override
        protected UpdateBuilder self() {
            return this;
        }
    }

    public static class UpdateNetwork
    extends Network {
        private UpdateNetwork(Network network) {
            super(network);
        }
    }

    public static class CreateNetwork
    extends Network {
        private CreateNetwork(Network network) {
            super(network);
            Preconditions.checkNotNull((Object)network.name, (Object)"name should not be null");
        }
    }

    private static abstract class Builder<ParameterizedBuilderType> {
        protected Network network = new Network();

        private Builder() {
        }

        protected abstract ParameterizedBuilderType self();

        public ParameterizedBuilderType name(String name) {
            this.network.name = name;
            return this.self();
        }

        public ParameterizedBuilderType adminStateUp(Boolean adminStateUp) {
            this.network.adminStateUp = adminStateUp;
            return this.self();
        }

        public ParameterizedBuilderType shared(Boolean shared) {
            this.network.shared = shared;
            return this.self();
        }

        public ParameterizedBuilderType tenantId(String tenantId) {
            this.network.tenantId = tenantId;
            return this.self();
        }

        public ParameterizedBuilderType availabilityZone(String availabilityZone) {
            this.network.availabilityZone = availabilityZone;
            return this.self();
        }

        public ParameterizedBuilderType networkType(NetworkType networkType) {
            this.network.networkType = networkType;
            return this.self();
        }

        public ParameterizedBuilderType physicalNetworkName(String physicalNetworkName) {
            this.network.physicalNetworkName = physicalNetworkName;
            return this.self();
        }

        public ParameterizedBuilderType segmentationId(Integer segmentationId) {
            this.network.segmentationId = segmentationId;
            return this.self();
        }

        public ParameterizedBuilderType external(Boolean external) {
            this.network.external = external;
            return this.self();
        }

        public ParameterizedBuilderType portSecurity(Boolean portSecurity) {
            this.network.portSecurity = portSecurity;
            return this.self();
        }

        public ParameterizedBuilderType profileId(String profileId) {
            this.network.profileId = profileId;
            return this.self();
        }

        public ParameterizedBuilderType multicastIp(String multicastIp) {
            this.network.multicastIp = multicastIp;
            return this.self();
        }

        public ParameterizedBuilderType segmentAdd(String segmentAdd) {
            this.network.segmentAdd = segmentAdd;
            return this.self();
        }

        public ParameterizedBuilderType segmentDel(String segmentDel) {
            this.network.segmentDel = segmentDel;
            return this.self();
        }

        public ParameterizedBuilderType memberSegments(String memberSegments) {
            this.network.memberSegments = memberSegments;
            return this.self();
        }

        public ParameterizedBuilderType segments(ImmutableSet<NetworkSegment> segments) {
            this.network.segments = segments;
            return this.self();
        }

        public ParameterizedBuilderType networkFlavor(String networkFlavor) {
            this.network.networkFlavor = networkFlavor;
            return this.self();
        }
    }
}

