/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.openstack.keystone.auth.config.AuthenticationModule;
import org.jclouds.openstack.keystone.catalog.config.ServiceCatalogModule;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.config.NeutronHttpApiModule;
import org.jclouds.rest.internal.BaseHttpApiMetadata;

@AutoService(value={ApiMetadata.class})
public class NeutronApiMetadata
extends BaseHttpApiMetadata<NeutronApi> {
    public Builder toBuilder() {
        return new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public NeutronApiMetadata() {
        this(new Builder());
    }

    protected NeutronApiMetadata(Builder builder) {
        super((BaseHttpApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = BaseHttpApiMetadata.defaultProperties();
        properties.setProperty("jclouds.keystone.service-type", "network");
        properties.setProperty("jclouds.keystone.credential-type", "passwordCredentials");
        properties.setProperty("jclouds.keystone.version", "2");
        return properties;
    }

    public static class Builder
    extends BaseHttpApiMetadata.Builder<NeutronApi, Builder> {
        protected Builder() {
            super(NeutronApi.class);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("openstack-neutron")).name("OpenStack Neutron API")).identityName("${tenantName}:${userName} or ${userName}, if your keystone supports a default tenant")).credentialName("${password}")).endpointName("Neutron base url ending in /v2.0/")).documentation(URI.create("http://docs.openstack.org/api/openstack-network/2.0/content/"))).version("v2.0")).defaultEndpoint("http://localhost:5000/v2.0/")).defaultProperties(NeutronApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(AuthenticationModule.class).add(ServiceCatalogModule.class).add(ServiceCatalogModule.RegionModule.class).add(NeutronHttpApiModule.class).build());
        }

        public NeutronApiMetadata build() {
            return new NeutronApiMetadata(this);
        }

        public Builder fromApiMetadata(ApiMetadata in) {
            super.fromApiMetadata(in);
            return this;
        }

        protected Builder self() {
            return this;
        }
    }
}

