/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ssh.jsch.config;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scopes;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import jakarta.inject.Named;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.proxy.ProxyConfig;
import org.jclouds.ssh.SshClient;
import org.jclouds.ssh.config.ConfiguresSshClient;
import org.jclouds.ssh.jsch.JschSshClient;

@ConfiguresSshClient
public class JschSshClientModule
extends AbstractModule {
    protected void configure() {
        this.bind(SshClient.Factory.class).to(Factory.class).in(Scopes.SINGLETON);
    }

    private static class Factory
    implements SshClient.Factory {
        @Named(value="jclouds.connection-timeout")
        @Inject(optional=true)
        int timeout = 60000;
        Optional<Connector> agentConnector = this.getAgentConnector();
        private final ProxyConfig proxyConfig;
        private final BackoffLimitedRetryHandler backoffLimitedRetryHandler;
        private final Injector injector;

        Optional<Connector> getAgentConnector() {
            ConnectorFactory sshAgentOverNetcatOnly = new ConnectorFactory(){
                {
                    this.setPreferredConnectors("ssh-agent");
                    this.setPreferredUSocketFactories("nc");
                }
            };
            try {
                return Optional.of((Object)sshAgentOverNetcatOnly.createConnector());
            }
            catch (AgentProxyException e) {
                return Optional.absent();
            }
        }

        @Inject
        public Factory(ProxyConfig proxyConfig, BackoffLimitedRetryHandler backoffLimitedRetryHandler, Injector injector) {
            this.proxyConfig = (ProxyConfig)Preconditions.checkNotNull((Object)proxyConfig, (Object)"proxyConfig");
            this.backoffLimitedRetryHandler = (BackoffLimitedRetryHandler)Preconditions.checkNotNull((Object)backoffLimitedRetryHandler, (Object)"backoffLimitedRetryHandler");
            this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector");
        }

        public SshClient create(HostAndPort socket, LoginCredentials credentials) {
            JschSshClient client = new JschSshClient(this.proxyConfig, this.backoffLimitedRetryHandler, socket, credentials, this.timeout, this.getAgentConnector());
            this.injector.injectMembers((Object)client);
            return client;
        }

        public boolean isAgentAvailable() {
            return this.agentConnector.isPresent();
        }
    }
}

