/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.b2.filters;

import com.google.inject.Singleton;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import org.jclouds.b2.B2Api;
import org.jclouds.b2.domain.GetUploadPartResponse;
import org.jclouds.b2.domain.UploadUrlResponse;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.logging.Logger;

@Singleton
public final class B2RetryHandler
extends BackoffLimitedRetryHandler
implements HttpRequestFilter {
    private final B2Api api;
    @Resource
    private Logger logger = Logger.NULL;

    @Inject
    B2RetryHandler(B2Api api) {
        this.api = api;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        HttpRequest.Builder builder = request.toBuilder();
        String path = request.getEndpoint().getPath();
        if (path.startsWith("/b2api/v2/b2_upload_file")) {
            String bucketId = path.split("/")[4];
            UploadUrlResponse uploadUrl = this.api.getObjectApi().getUploadUrl(bucketId);
            builder.endpoint(uploadUrl.uploadUrl()).replaceHeader("Authorization", new String[]{uploadUrl.authorizationToken()});
        } else if (path.startsWith("/b2api/v2/b2_upload_part")) {
            String fileId = path.split("/")[4];
            GetUploadPartResponse uploadUrl = this.api.getMultipartApi().getUploadPartUrl(fileId);
            builder.endpoint(uploadUrl.uploadUrl()).replaceHeader("Authorization", new String[]{uploadUrl.authorizationToken()});
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        boolean retry = false;
        try {
            byte[] data = HttpUtils.closeClientButKeepContentStream((PayloadEnclosing)response);
            switch (response.getStatusCode()) {
                case 500: 
                case 503: {
                    retry = super.shouldRetryRequest(command, response);
                    return retry;
                }
            }
            return retry;
        }
        finally {
            HttpUtils.releasePayload((HttpMessage)response);
        }
    }
}

