/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.toml;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Arrays;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.VersionUtil;
import tools.jackson.dataformat.toml.PackageVersion;
import tools.jackson.dataformat.toml.StringOutputUtil;
import tools.jackson.dataformat.toml.TomlStreamWriteException;
import tools.jackson.dataformat.toml.TomlWriteContext;
import tools.jackson.dataformat.toml.TomlWriteFeature;

final class TomlGenerator
extends GeneratorBase {
    protected static final int SHORT_WRITE = 100;
    protected final Writer _out;
    private final int _tomlFeatures;
    protected TomlWriteContext _streamWriteContext;
    protected char[] _outputBuffer;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected final StringBuilder _basePath = new StringBuilder(50);

    public TomlGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int stdFeatures, int tomlFeatures, Writer out) {
        super(writeCtxt, ioCtxt, stdFeatures);
        this._tomlFeatures = tomlFeatures;
        this._streamWriteContext = TomlWriteContext.createRootContext();
        this._out = out;
        this._outputBuffer = ioCtxt.allocConcatBuffer();
        this._outputEnd = this._outputBuffer.length;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public Object streamWriteOutputTarget() {
        return this._out;
    }

    public int streamWriteOutputBuffered() {
        return this._outputTail;
    }

    public void close() {
        if (!this.isClosed()) {
            this._flushBuffer();
            super.close();
            this._outputTail = 0;
        }
    }

    protected void _closeInput() throws IOException {
        if (this._out != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._out.close();
            } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._out.flush();
            }
        }
    }

    public void flush() {
        this._flushBuffer();
        if (this._out != null && this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._out.flush();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    protected void _releaseBuffers() {
        char[] buf = this._outputBuffer;
        if (buf != null) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }

    protected void _flushBuffer() throws JacksonException {
        if (this._outputTail > 0 && this._out != null) {
            try {
                this._out.write(this._outputBuffer, 0, this._outputTail);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            this._outputTail = 0;
        }
    }

    protected JsonGenerator _writeRaw(char c) throws JacksonException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
        return this;
    }

    protected JsonGenerator _writeRaw(String text) throws JacksonException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this._writeRawLong(text);
        }
        return this;
    }

    protected JsonGenerator _writeRaw(StringBuilder text) throws JacksonException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this._writeRawLong(text);
        }
        return this;
    }

    protected JsonGenerator _writeRaw(char[] text, int offset, int len) throws JacksonException {
        if (len < 100) {
            int room = this._outputEnd - this._outputTail;
            if (len > room) {
                this._flushBuffer();
            }
            System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
            this._outputTail += len;
            return this;
        }
        this._flushBuffer();
        try {
            this._out.write(text, offset, len);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    protected void _writeRawLong(String text) throws JacksonException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    protected void _writeRawLong(StringBuilder text) throws JacksonException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    public TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public boolean canWriteObjectId() {
        return false;
    }

    public boolean canWriteTypeId() {
        return false;
    }

    public boolean canOmitProperties() {
        return true;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_WRITE_CAPABILITIES;
    }

    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        if (!this._streamWriteContext.writeName(name)) {
            this._reportError("Cannot write a property name, expecting a value");
        }
        if (this._streamWriteContext._inline) {
            if (this._streamWriteContext.hasCurrentIndex()) {
                this._writeRaw(", ");
            }
            this._writeStringImpl(-1, name);
        } else {
            this._streamWriteContext.truncatePath(this._basePath);
            if (this._basePath.length() > 0) {
                this._basePath.append('.');
            }
            this._appendPropertyName(this._basePath, name);
        }
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        return this.writeName(Long.toString(id));
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        return this.writeStartArray(null);
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this._verifyValueWrite("start an array", true);
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue, this._basePath.length());
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._streamWriteContext._inline) {
            this._writeRaw('[');
        }
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not an Array but " + this._streamWriteContext.typeDesc());
        }
        if (this._streamWriteContext._inline) {
            this._writeRaw(']');
        } else if (!this._streamWriteContext.hasCurrentIndex()) {
            VersionUtil.throwInternal();
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        return this.writeValueEnd();
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        return this.writeStartObject(null);
    }

    public JsonGenerator writeStartObject(Object forValue) throws JacksonException {
        this._verifyValueWrite("start an object", false);
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(forValue, this._basePath.length());
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        if (this._streamWriteContext._inline) {
            this.writeRaw('{');
        }
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not an Object but " + this._streamWriteContext.typeDesc());
        }
        if (this._streamWriteContext._inline) {
            this.writeRaw('}');
            this._streamWriteContext = this._streamWriteContext.getParent();
            this.writeValueEnd();
        } else {
            if (!this._streamWriteContext.hasCurrentIndex()) {
                this.writeCurrentPath();
                this._writeRaw("{}");
                this.writeValueEnd();
            }
            this._streamWriteContext = this._streamWriteContext.getParent();
        }
        return this;
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        if (text == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write String value");
        this._writeStringImpl(-2, text);
        return this.writeValueEnd();
    }

    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        this._verifyValueWrite("write String value");
        this._writeStringImpl(-2, text, offset, len);
        return this.writeValueEnd();
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        this.writeString(new String(text, offset, len, StandardCharsets.UTF_8));
        return this.writeValueEnd();
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        return this._writeRaw(text);
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        return this._writeRaw(text.substring(offset, offset + len));
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        return this._writeRaw(text, offset, len);
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        return this._writeRaw(c);
    }

    public JsonGenerator writeRaw(SerializableString text) throws JacksonException {
        return this.writeRaw(text.toString());
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write Binary value");
        if (offset > 0 || offset + len != data.length) {
            data = Arrays.copyOfRange(data, offset, offset + len);
        }
        String encoded = b64variant.encode(data);
        this._writeRaw('\'');
        this._writeRaw(encoded);
        this._writeRaw('\'');
        return this.writeValueEnd();
    }

    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        this._verifyValueWrite("write boolean value");
        this._writeRaw(state ? "true" : "false");
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        this.writeNumber((int)v);
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(int i) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(i));
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(long l) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(l));
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(v));
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(double d) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(d));
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(float f) throws JacksonException {
        this._verifyValueWrite("write number");
        this._writeRaw(String.valueOf(f));
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(BigDecimal dec) throws JacksonException {
        if (dec == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        String str = this.isEnabled(StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN) ? dec.toPlainString() : dec.toString();
        this._writeRaw(str);
        return this.writeValueEnd();
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        if (encodedValue == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write number");
        this._writeRaw(encodedValue);
        return this.writeValueEnd();
    }

    public JsonGenerator writeNull() throws JacksonException {
        if (TomlWriteFeature.FAIL_ON_NULL_WRITE.enabledIn(this._tomlFeatures)) {
            throw new TomlStreamWriteException((JsonGenerator)this, "TOML null writing disabled (TomlWriteFeature.FAIL_ON_NULL_WRITE)");
        }
        this._verifyValueWrite("write null value");
        this._writeStringImpl(-2, "");
        return this.writeValueEnd();
    }

    protected void _verifyValueWrite(String typeMsg) throws JacksonException {
        this._verifyValueWrite(typeMsg, true);
    }

    protected void _verifyValueWrite(String typeMsg, boolean forceMaterializeKey) throws JacksonException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Cannot " + typeMsg + ", expecting a property name");
        }
        if (this._streamWriteContext._inline) {
            if (this._streamWriteContext.inArray()) {
                if (this._streamWriteContext.getCurrentIndex() != 0) {
                    this._writeRaw(", ");
                }
            } else {
                this._writeRaw(" = ");
            }
        } else if (forceMaterializeKey) {
            this.writeCurrentPath();
        }
    }

    private void writeCurrentPath() {
        this._writeRaw(this._basePath);
        this._writeRaw(" = ");
    }

    private JsonGenerator writeValueEnd() {
        if (!this._streamWriteContext._inline) {
            this.writeRaw('\n');
        }
        return this;
    }

    private void _appendPropertyName(StringBuilder path, String name) {
        int cat = StringOutputUtil.categorize(name) & 0xFFFFFFFF;
        if ((cat & 1) != 0) {
            path.append(name);
        } else if ((cat & 2) != 0) {
            path.append('\'').append(name).append('\'');
        } else if ((cat & 8) != 0) {
            path.append('\"').append(name).append('\"');
        } else if ((cat & 4) != 0) {
            path.append('\"');
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                String escape = StringOutputUtil.getBasicStringEscape(c);
                if (escape == null) {
                    path.append(c);
                    continue;
                }
                path.append(escape);
            }
            path.append('\"');
        } else {
            throw this._constructWriteException("Key contains unsupported characters");
        }
    }

    private void _writeStringImpl(int categoryMask, String name) {
        int cat = StringOutputUtil.categorize(name) & categoryMask;
        if ((cat & 1) != 0) {
            this._writeRaw(name);
        } else if ((cat & 2) != 0) {
            this._writeRaw('\'');
            this._writeRaw(name);
            this._writeRaw('\'');
        } else if ((cat & 8) != 0) {
            this._writeRaw('\"');
            this._writeRaw(name);
            this._writeRaw('\"');
        } else if ((cat & 4) != 0) {
            this._writeRaw('\"');
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                String escape = StringOutputUtil.getBasicStringEscape(c);
                if (escape == null) {
                    this._writeRaw(c);
                    continue;
                }
                this._writeRaw(escape);
            }
            this._writeRaw('\"');
        } else {
            throw this._constructWriteException("Key contains unsupported characters");
        }
    }

    private void _writeStringImpl(int categoryMask, char[] text, int offset, int len) {
        int cat = StringOutputUtil.categorize(text, offset, len) & categoryMask;
        if ((cat & 1) != 0) {
            this._writeRaw(text, offset, len);
        } else if ((cat & 2) != 0) {
            this._writeRaw('\'');
            this._writeRaw(text, offset, len);
            this._writeRaw('\'');
        } else if ((cat & 8) != 0) {
            this._writeRaw('\"');
            this._writeRaw(text, offset, len);
            this._writeRaw('\"');
        } else if ((cat & 4) != 0) {
            this._writeRaw('\"');
            for (int i = 0; i < len; ++i) {
                char c = text[offset + len];
                String escape = StringOutputUtil.getBasicStringEscape(c);
                if (escape == null) {
                    this._writeRaw(c);
                    continue;
                }
                this._writeRaw(escape);
            }
            this._writeRaw('\"');
        } else {
            throw this._constructWriteException("Key contains unsupported characters");
        }
    }

    public JsonGenerator writePOJO(Object value) throws JacksonException {
        if (value == null) {
            this.writeNull();
        } else if (value instanceof LocalDate || value instanceof LocalTime || value instanceof LocalDateTime || value instanceof OffsetDateTime) {
            this._verifyValueWrite("write local date");
            this._writeRaw(value.toString());
            this.writeValueEnd();
        } else {
            this._objectWriteContext.writeValue((JsonGenerator)this, value);
        }
        return this;
    }
}

