/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.toml;

import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.dataformat.toml.TomlFactory;
import tools.jackson.dataformat.toml.TomlReadFeature;
import tools.jackson.dataformat.toml.TomlWriteFeature;

public class TomlFactoryBuilder
extends DecorableTSFactory.DecorableTSFBuilder<TomlFactory, TomlFactoryBuilder> {
    TomlFactoryBuilder() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), TomlFactory.DEFAULT_TOML_PARSER_FEATURE_FLAGS, TomlFactory.DEFAULT_TOML_GENERATOR_FEATURE_FLAGS);
    }

    TomlFactoryBuilder(TomlFactory base) {
        super((DecorableTSFactory)base);
    }

    public TomlFactory build() {
        return new TomlFactory(this);
    }

    public TomlFactoryBuilder enable(TomlReadFeature f) {
        this._formatReadFeatures |= f.getMask();
        return this;
    }

    public TomlFactoryBuilder enable(TomlReadFeature first, TomlReadFeature ... other) {
        this._formatReadFeatures |= first.getMask();
        for (TomlReadFeature f : other) {
            this._formatReadFeatures |= f.getMask();
        }
        return this;
    }

    public TomlFactoryBuilder disable(TomlReadFeature f) {
        this._formatReadFeatures &= ~f.getMask();
        return this;
    }

    public TomlFactoryBuilder disable(TomlReadFeature first, TomlReadFeature ... other) {
        this._formatReadFeatures &= ~first.getMask();
        for (TomlReadFeature f : other) {
            this._formatReadFeatures &= ~f.getMask();
        }
        return this;
    }

    public TomlFactoryBuilder configure(TomlReadFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public TomlFactoryBuilder enable(TomlWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return this;
    }

    public TomlFactoryBuilder enable(TomlWriteFeature first, TomlWriteFeature ... other) {
        this._formatWriteFeatures |= first.getMask();
        for (TomlWriteFeature f : other) {
            this._formatWriteFeatures |= f.getMask();
        }
        return this;
    }

    public TomlFactoryBuilder disable(TomlWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return this;
    }

    public TomlFactoryBuilder disable(TomlWriteFeature first, TomlWriteFeature ... other) {
        this._formatWriteFeatures &= ~first.getMask();
        for (TomlWriteFeature f : other) {
            this._formatWriteFeatures &= ~f.getMask();
        }
        return this;
    }

    public TomlFactoryBuilder configure(TomlWriteFeature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }
}

