/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.node;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.OptionalDouble;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.io.NumberOutput;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.node.NumericFPNode;

public class DoubleNode
extends NumericFPNode {
    private static final long serialVersionUID = 3L;
    protected final double _value;

    public DoubleNode(double v) {
        this._value = v;
    }

    public static DoubleNode valueOf(double v) {
        return new DoubleNode(v);
    }

    @Override
    public JsonParser.NumberType numberType() {
        return JsonParser.NumberType.DOUBLE;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public boolean isNaN() {
        return NumberOutput.notFinite((double)this._value);
    }

    @Override
    protected String _asString() {
        return String.valueOf(this._value);
    }

    @Override
    public Number numberValue() {
        return this._value;
    }

    @Override
    public float floatValue() {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("floatValue()");
    }

    @Override
    public float floatValue(float defaultValue) {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return f;
        }
        return defaultValue;
    }

    @Override
    public Optional<Float> floatValueOpt() {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return Optional.of(Float.valueOf(f));
        }
        return Optional.empty();
    }

    @Override
    public float asFloat() {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return f;
        }
        return this._reportFloatCoercionRangeFail("asFloat()");
    }

    @Override
    public float asFloat(float defaultValue) {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return f;
        }
        return defaultValue;
    }

    @Override
    public Optional<Float> asFloatOpt() {
        float f = (float)this._value;
        if (Float.isFinite(f)) {
            return Optional.of(Float.valueOf(f));
        }
        return Optional.empty();
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public double doubleValue(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble doubleValueOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public double asDouble() {
        return this._value;
    }

    @Override
    public double asDouble(double defaultValue) {
        return this._value;
    }

    @Override
    public OptionalDouble asDoubleOpt() {
        return OptionalDouble.of(this._value);
    }

    @Override
    public short _asShortValueUnchecked() {
        return (short)this._value;
    }

    @Override
    public int _asIntValueUnchecked() {
        return (int)this._value;
    }

    @Override
    public long _asLongValueUnchecked() {
        return (long)this._value;
    }

    @Override
    protected BigInteger _asBigIntegerValueUnchecked() {
        return BigDecimal.valueOf(this._value).toBigInteger();
    }

    @Override
    protected BigDecimal _asDecimalValueUnchecked() {
        return BigDecimal.valueOf(this._value);
    }

    @Override
    public boolean hasFractionalPart() {
        return this._value != Math.rint(this._value);
    }

    @Override
    public boolean inShortRange() {
        return !this.isNaN() && this._value >= -32768.0 && this._value <= 32767.0;
    }

    @Override
    public boolean inIntRange() {
        return !this.isNaN() && this._value >= -2.147483648E9 && this._value <= 2.147483647E9;
    }

    @Override
    public boolean inLongRange() {
        return !this.isNaN() && this._value >= -9.223372036854776E18 && this._value <= 9.223372036854776E18;
    }

    @Override
    public final void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        g.writeNumber(this._value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof DoubleNode) {
            double otherValue = ((DoubleNode)o)._value;
            return Double.compare(this._value, otherValue) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this._value);
        return (int)l ^ (int)(l >> 32);
    }
}

