/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.util;

import java.lang.ref.SoftReference;
import tools.jackson.core.util.BufferRecycler;
import tools.jackson.core.util.RecyclerPool;

public final class JsonRecyclerPools {
    public static RecyclerPool<BufferRecycler> defaultPool() {
        return JsonRecyclerPools.newConcurrentDequePool();
    }

    public static RecyclerPool<BufferRecycler> threadLocalPool() {
        return ThreadLocalPool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> nonRecyclingPool() {
        return NonRecyclingPool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> sharedConcurrentDequePool() {
        return ConcurrentDequePool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> newConcurrentDequePool() {
        return ConcurrentDequePool.construct();
    }

    public static RecyclerPool<BufferRecycler> sharedBoundedPool() {
        return BoundedPool.GLOBAL;
    }

    public static RecyclerPool<BufferRecycler> newBoundedPool(int size) {
        return BoundedPool.construct(size);
    }

    public static class ThreadLocalPool
    extends RecyclerPool.ThreadLocalPoolBase<BufferRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final ThreadLocalPool GLOBAL = new ThreadLocalPool();
        protected static final ThreadLocal<SoftReference<BufferRecycler>> _recyclerRef = new ThreadLocal();

        private ThreadLocalPool() {
        }

        @Override
        public BufferRecycler acquirePooled() {
            BufferRecycler br;
            SoftReference<BufferRecycler> ref = _recyclerRef.get();
            BufferRecycler bufferRecycler = br = ref == null ? null : ref.get();
            if (br == null) {
                br = new BufferRecycler();
                ref = new SoftReference<BufferRecycler>(br);
                _recyclerRef.set(ref);
            }
            return br;
        }

        protected Object readResolve() {
            return GLOBAL;
        }
    }

    public static class NonRecyclingPool
    extends RecyclerPool.NonRecyclingPoolBase<BufferRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final NonRecyclingPool GLOBAL = new NonRecyclingPool();

        protected NonRecyclingPool() {
        }

        @Override
        public BufferRecycler acquirePooled() {
            return new BufferRecycler();
        }

        protected Object readResolve() {
            return GLOBAL;
        }
    }

    public static class ConcurrentDequePool
    extends RecyclerPool.ConcurrentDequePoolBase<BufferRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final ConcurrentDequePool GLOBAL = new ConcurrentDequePool(-1);

        protected ConcurrentDequePool(int serialization) {
            super(serialization);
        }

        public static ConcurrentDequePool construct() {
            return new ConcurrentDequePool(1);
        }

        @Override
        public BufferRecycler createPooled() {
            return new BufferRecycler();
        }

        protected Object readResolve() {
            return this._resolveToShared(GLOBAL).orElseGet(() -> ConcurrentDequePool.construct());
        }
    }

    public static class BoundedPool
    extends RecyclerPool.BoundedPoolBase<BufferRecycler> {
        private static final long serialVersionUID = 1L;
        protected static final BoundedPool GLOBAL = new BoundedPool(-1);

        protected BoundedPool(int capacityAsId) {
            super(capacityAsId);
        }

        public static BoundedPool construct(int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException("capacity must be > 0, was: " + capacity);
            }
            return new BoundedPool(capacity);
        }

        @Override
        public BufferRecycler createPooled() {
            return new BufferRecycler();
        }

        protected Object readResolve() {
            return this._resolveToShared(GLOBAL).orElseGet(() -> BoundedPool.construct(this._serialization));
        }
    }
}

