/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.util.ClassUtil;

public class RawValue
implements JacksonSerializable {
    protected Object _value;

    public RawValue(String v) {
        this._value = v;
    }

    public RawValue(SerializableString v) {
        this._value = v;
    }

    public RawValue(JacksonSerializable v) {
        this._value = v;
    }

    protected RawValue(Object value, boolean bogus) {
        this._value = value;
    }

    public Object rawValue() {
        return this._value;
    }

    @Override
    public void serialize(JsonGenerator gen, SerializationContext serializers) throws JacksonException {
        if (this._value instanceof JacksonSerializable) {
            ((JacksonSerializable)this._value).serialize(gen, serializers);
        } else {
            this._serialize(gen);
        }
    }

    @Override
    public void serializeWithType(JsonGenerator gen, SerializationContext serializers, TypeSerializer typeSer) throws JacksonException {
        if (this._value instanceof JacksonSerializable) {
            ((JacksonSerializable)this._value).serializeWithType(gen, serializers, typeSer);
        } else if (this._value instanceof SerializableString) {
            this.serialize(gen, serializers);
        }
    }

    public void serialize(JsonGenerator gen) throws JacksonException {
        if (this._value instanceof JacksonSerializable) {
            gen.writePOJO(this._value);
        } else {
            this._serialize(gen);
        }
    }

    protected void _serialize(JsonGenerator gen) throws JacksonException {
        if (this._value instanceof SerializableString) {
            gen.writeRawValue((SerializableString)this._value);
        } else {
            gen.writeRawValue(String.valueOf(this._value));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawValue)) {
            return false;
        }
        RawValue other = (RawValue)o;
        if (this._value == other._value) {
            return true;
        }
        return this._value != null && this._value.equals(other._value);
    }

    public int hashCode() {
        return this._value == null ? 0 : this._value.hashCode();
    }

    public String toString() {
        return String.format("[RawValue of type %s]", ClassUtil.classNameOf(this._value));
    }
}

