/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JacksonSerializable;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeSerializer;

public class JSONWrappedObject
implements JacksonSerializable {
    protected final String _prefix;
    protected final String _suffix;
    protected final Object _value;
    protected final JavaType _serializationType;

    public JSONWrappedObject(String prefix, String suffix, Object value) {
        this(prefix, suffix, value, null);
    }

    public JSONWrappedObject(String prefix, String suffix, Object value, JavaType asType) {
        this._prefix = prefix;
        this._suffix = suffix;
        this._value = value;
        this._serializationType = asType;
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializationContext provider, TypeSerializer typeSer) throws JacksonException {
        this.serialize(g, provider);
    }

    @Override
    public void serialize(JsonGenerator g, SerializationContext provider) throws JacksonException {
        if (this._prefix != null) {
            g.writeRaw(this._prefix);
        }
        if (this._value == null) {
            provider.defaultSerializeNullValue(g);
        } else if (this._serializationType != null) {
            provider.findTypedValueSerializer(this._serializationType, true).serialize(this._value, g, provider);
        } else {
            provider.findTypedValueSerializer(this._value.getClass(), true).serialize(this._value, g, provider);
        }
        if (this._suffix != null) {
            g.writeRaw(this._suffix);
        }
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getSuffix() {
        return this._suffix;
    }

    public Object getValue() {
        return this._value;
    }

    public JavaType getSerializationType() {
        return this._serializationType;
    }
}

