/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser.key;

import java.time.DateTimeException;
import java.time.Year;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ext.javatime.deser.key.Jsr310KeyDeserializer;

public class YearKeyDeserializer
extends Jsr310KeyDeserializer {
    public static final YearKeyDeserializer INSTANCE = new YearKeyDeserializer();

    private YearKeyDeserializer() {
    }

    @Override
    protected Year deserialize(String key, DeserializationContext ctxt) throws JacksonException {
        try {
            return Year.of(Integer.parseInt(key));
        }
        catch (NumberFormatException nfe) {
            return (Year)this._handleDateTimeException(ctxt, Year.class, new DateTimeException("Number format exception", nfe), key);
        }
        catch (DateTimeException dte) {
            return (Year)this._handleDateTimeException(ctxt, Year.class, dte, key);
        }
    }
}

