/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.introspect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotationCollector;
import tools.jackson.databind.introspect.CollectorBase;
import tools.jackson.databind.introspect.MixInResolver;
import tools.jackson.databind.introspect.TypeResolutionContext;
import tools.jackson.databind.util.ClassUtil;

public class AnnotatedFieldCollector
extends CollectorBase {
    private final MixInResolver _mixInResolver;
    private final boolean _collectAnnotations;

    AnnotatedFieldCollector(MapperConfig<?> config, MixInResolver mixins, boolean collectAnnotations) {
        super(config);
        this._mixInResolver = mixins;
        this._collectAnnotations = collectAnnotations;
    }

    public static List<AnnotatedField> collectFields(MapperConfig<?> config, TypeResolutionContext tc, MixInResolver mixins, JavaType type, Class<?> primaryMixIn, boolean collectAnnotations) {
        return new AnnotatedFieldCollector(config, mixins, collectAnnotations).collect(tc, type, primaryMixIn);
    }

    List<AnnotatedField> collect(TypeResolutionContext tc, JavaType type, Class<?> primaryMixIn) {
        Map<String, FieldBuilder> foundFields = this._findFields(tc, type, primaryMixIn, null);
        if (foundFields == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotatedField> result = new ArrayList<AnnotatedField>(foundFields.size());
        for (FieldBuilder b : foundFields.values()) {
            result.add(b.build());
        }
        return result;
    }

    private Map<String, FieldBuilder> _findFields(TypeResolutionContext tc, JavaType type, Class<?> mixin, Map<String, FieldBuilder> fields) {
        JavaType parentType = type.getSuperClass();
        if (parentType == null) {
            return fields;
        }
        Class<?> parentMixin = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(parentType.getRawClass());
        fields = this._findFields(new TypeResolutionContext.Basic(this._config.getTypeFactory(), parentType.getBindings()), parentType, parentMixin, fields);
        Class<?> rawType = type.getRawClass();
        for (Field f : rawType.getDeclaredFields()) {
            if (!this._isIncludableField(f)) continue;
            if (fields == null) {
                fields = new LinkedHashMap<String, FieldBuilder>();
            }
            FieldBuilder b = new FieldBuilder(tc, f);
            if (this._collectAnnotations) {
                b.annotations = this.collectAnnotations(b.annotations, f.getDeclaredAnnotations());
            }
            fields.put(f.getName(), b);
        }
        if (fields != null && mixin != null) {
            this._addFieldMixIns(mixin, rawType, fields);
        }
        return fields;
    }

    private void _addFieldMixIns(Class<?> mixInCls, Class<?> targetClass, Map<String, FieldBuilder> fields) {
        List<Class<?>> parents = ClassUtil.findSuperClasses(mixInCls, targetClass, true);
        for (Class<?> mixin : parents) {
            for (Field mixinField : mixin.getDeclaredFields()) {
                String name;
                FieldBuilder b;
                if (!this._isIncludableField(mixinField) || (b = fields.get(name = mixinField.getName())) == null) continue;
                b.annotations = this.collectAnnotations(b.annotations, mixinField.getDeclaredAnnotations());
            }
        }
    }

    private boolean _isIncludableField(Field f) {
        if (f.isEnumConstant()) {
            return true;
        }
        if (f.isSynthetic()) {
            return false;
        }
        return !Modifier.isStatic(f.getModifiers());
    }

    private static final class FieldBuilder {
        public final TypeResolutionContext typeContext;
        public final Field field;
        public AnnotationCollector annotations;

        public FieldBuilder(TypeResolutionContext tc, Field f) {
            this.typeContext = tc;
            this.field = f;
            this.annotations = AnnotationCollector.emptyCollector();
        }

        public AnnotatedField build() {
            return new AnnotatedField(this.typeContext, this.field, this.annotations.asAnnotationMap());
        }
    }
}

