/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.beans;

import java.beans.ConstructorProperties;
import java.beans.Transient;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ext.beans.JavaBeansAnnotations;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.AnnotatedWithParams;

public class JavaBeansAnnotationsImpl
extends JavaBeansAnnotations {
    public static final JavaBeansAnnotationsImpl instance = new JavaBeansAnnotationsImpl();
    private final Class<?> _bogus;

    public JavaBeansAnnotationsImpl() {
        Class cls = Transient.class;
        cls = ConstructorProperties.class;
        this._bogus = cls;
    }

    @Override
    public Boolean findTransient(Annotated a) {
        Transient t = a.getAnnotation(Transient.class);
        if (t != null) {
            return t.value();
        }
        return null;
    }

    @Override
    public Boolean hasCreatorAnnotation(Annotated a) {
        ConstructorProperties props = a.getAnnotation(ConstructorProperties.class);
        if (props != null) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public PropertyName findConstructorName(AnnotatedParameter p) {
        ConstructorProperties props;
        AnnotatedWithParams ctor = p.getOwner();
        if (ctor != null && (props = ctor.getAnnotation(ConstructorProperties.class)) != null) {
            String[] names = props.value();
            int ix = p.getIndex();
            if (ix < names.length) {
                return PropertyName.construct(names[ix]);
            }
        }
        return null;
    }
}

