/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.cfg;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import tools.jackson.core.util.Snapshottable;
import tools.jackson.databind.cfg.ConfigOverride;
import tools.jackson.databind.cfg.MutableConfigOverride;
import tools.jackson.databind.introspect.VisibilityChecker;

public class ConfigOverrides
implements Serializable,
Snapshottable<ConfigOverrides> {
    private static final long serialVersionUID = 3L;
    static final JsonInclude.Value INCLUDE_DEFAULT = JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.USE_DEFAULTS, (JsonInclude.Include)JsonInclude.Include.USE_DEFAULTS);
    private static final VisibilityChecker DEFAULT_VISIBILITY_CHECKER = VisibilityChecker.defaultInstance();
    private static final VisibilityChecker DEFAULT_RECORD_VISIBILITY_CHECKER = VisibilityChecker.allPublicExceptCreatorsInstance();
    protected Map<Class<?>, MutableConfigOverride> _overrides;
    protected JsonInclude.Value _defaultInclusion;
    protected JsonSetter.Value _defaultNullHandling;
    protected VisibilityChecker _visibilityChecker;
    protected Boolean _defaultMergeable;
    protected Boolean _defaultLeniency;

    public ConfigOverrides() {
        this(null, INCLUDE_DEFAULT, JsonSetter.Value.empty(), DEFAULT_VISIBILITY_CHECKER, null, null);
    }

    protected ConfigOverrides(Map<Class<?>, MutableConfigOverride> overrides, JsonInclude.Value defIncl, JsonSetter.Value defSetter, VisibilityChecker defVisibility, Boolean defMergeable, Boolean defLeniency) {
        this._overrides = overrides;
        this._defaultInclusion = defIncl;
        this._defaultNullHandling = defSetter;
        this._visibilityChecker = defVisibility;
        this._defaultMergeable = defMergeable;
        this._defaultLeniency = defLeniency;
    }

    public ConfigOverrides snapshot() {
        Map<Class<?>, MutableConfigOverride> newOverrides;
        if (this._overrides == null) {
            newOverrides = null;
        } else {
            newOverrides = this._newMap();
            for (Map.Entry<Class<?>, MutableConfigOverride> entry : this._overrides.entrySet()) {
                newOverrides.put(entry.getKey(), entry.getValue().copy());
            }
        }
        return new ConfigOverrides(newOverrides, this._defaultInclusion, this._defaultNullHandling, this._visibilityChecker, this._defaultMergeable, this._defaultLeniency);
    }

    public ConfigOverride findOverride(Class<?> type) {
        if (this._overrides == null) {
            return null;
        }
        return this._overrides.get(type);
    }

    public MutableConfigOverride findOrCreateOverride(Class<?> type) {
        MutableConfigOverride override;
        if (this._overrides == null) {
            this._overrides = this._newMap();
        }
        if ((override = this._overrides.get(type)) == null) {
            override = new MutableConfigOverride();
            this._overrides.put(type, override);
        }
        return override;
    }

    public JsonFormat.Value findFormatDefaults(Class<?> type) {
        JsonFormat.Value format;
        ConfigOverride override;
        if (this._overrides != null && (override = (ConfigOverride)this._overrides.get(type)) != null && (format = override.getFormat()) != null) {
            if (!format.hasLenient()) {
                return format.withLenient(this._defaultLeniency);
            }
            return format;
        }
        if (this._defaultLeniency == null) {
            return JsonFormat.Value.empty();
        }
        return JsonFormat.Value.forLeniency((boolean)this._defaultLeniency);
    }

    public JsonInclude.Value getDefaultInclusion() {
        return this._defaultInclusion;
    }

    public JsonSetter.Value getDefaultNullHandling() {
        return this._defaultNullHandling;
    }

    public Boolean getDefaultMergeable() {
        return this._defaultMergeable;
    }

    public Boolean getDefaultLeniency() {
        return this._defaultLeniency;
    }

    public VisibilityChecker getDefaultVisibility() {
        return this._visibilityChecker;
    }

    public VisibilityChecker getDefaultRecordVisibility() {
        return DEFAULT_VISIBILITY_CHECKER.equals(this._visibilityChecker) ? DEFAULT_RECORD_VISIBILITY_CHECKER : this._visibilityChecker;
    }

    public ConfigOverrides setDefaultInclusion(JsonInclude.Value v) {
        this._defaultInclusion = v;
        return this;
    }

    public ConfigOverrides setDefaultNullHandling(JsonSetter.Value v) {
        this._defaultNullHandling = v;
        return this;
    }

    public ConfigOverrides setDefaultMergeable(Boolean b) {
        this._defaultMergeable = b;
        return this;
    }

    public ConfigOverrides setDefaultLeniency(Boolean b) {
        this._defaultLeniency = b;
        return this;
    }

    public ConfigOverrides setDefaultVisibility(VisibilityChecker v) {
        this._visibilityChecker = v;
        return this;
    }

    public ConfigOverrides setDefaultVisibility(JsonAutoDetect.Value vis) {
        this._visibilityChecker = VisibilityChecker.construct(vis);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ConfigOverrides ").append("incl=").append(this._defaultInclusion).append(", nulls=").append(this._defaultNullHandling).append(", merge=").append(this._defaultMergeable).append(", leniency=").append(this._defaultLeniency).append(", visibility=").append(this._visibilityChecker).append(", typed=");
        if (this._overrides == null) {
            sb.append("NLLL");
        } else {
            sb.append("(").append(this._overrides.size()).append("){");
            TreeMap<String, MutableConfigOverride> sorted = new TreeMap<String, MutableConfigOverride>();
            this._overrides.forEach((k, v) -> sorted.put(k.getName(), (MutableConfigOverride)v));
            sorted.forEach((k, v) -> sb.append(String.format("'%s'->%s", k, v)));
            sb.append("}");
        }
        return sb.append("]").toString();
    }

    protected Map<Class<?>, MutableConfigOverride> _newMap() {
        return new HashMap();
    }
}

