/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONArraySerializer;
import com.fasterxml.jackson.datatype.jsonorg.JSONBaseSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONObjectSerializer
extends JSONBaseSerializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectSerializer instance = new JSONObjectSerializer();

    public JSONObjectSerializer() {
        super(JSONObject.class);
    }

    public boolean isEmpty(SerializerProvider provider, JSONObject value) {
        return value == null || value.length() == 0;
    }

    public void serialize(JSONObject value, JsonGenerator g, SerializerProvider provider) throws IOException {
        g.writeStartObject((Object)value);
        this.serializeContents(value, g, provider);
        g.writeEndObject();
    }

    public void serializeWithType(JSONObject value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        g.assignCurrentValue((Object)value);
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value, JsonToken.START_OBJECT));
        this.serializeContents(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("object", true);
    }

    protected void serializeContents(JSONObject value, JsonGenerator g, SerializerProvider provider) throws IOException {
        Iterator it = value.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object ob = value.opt(key);
            if (ob == null || ob == JSONObject.NULL) {
                if (!provider.isEnabled(SerializationFeature.WRITE_NULL_MAP_VALUES)) continue;
                g.writeNullField(key);
                continue;
            }
            g.writeFieldName(key);
            Class<?> cls = ob.getClass();
            if (cls == JSONObject.class) {
                this.serialize((JSONObject)ob, g, provider);
                continue;
            }
            if (cls == JSONArray.class) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, g, provider);
                continue;
            }
            if (cls == String.class) {
                g.writeString((String)ob);
                continue;
            }
            if (cls == Integer.class) {
                g.writeNumber(((Integer)ob).intValue());
                continue;
            }
            if (cls == Long.class) {
                g.writeNumber(((Long)ob).longValue());
                continue;
            }
            if (cls == Boolean.class) {
                g.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (cls == Double.class) {
                g.writeNumber(((Double)ob).doubleValue());
                continue;
            }
            if (JSONObject.class.isAssignableFrom(cls)) {
                this.serialize((JSONObject)ob, g, provider);
                continue;
            }
            if (JSONArray.class.isAssignableFrom(cls)) {
                JSONArraySerializer.instance.serialize((JSONArray)ob, g, provider);
                continue;
            }
            provider.defaultSerializeValue(ob, g);
        }
    }
}

