/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsonorg;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.datatype.jsonorg.JSONArrayDeserializer;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JSONObject ob = new JSONObject();
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            block15: {
                String fieldName = p.currentName();
                t = p.nextToken();
                try {
                    switch (t) {
                        case START_ARRAY: {
                            ob.put(fieldName, (Object)JSONArrayDeserializer.instance.deserialize(p, ctxt));
                            break block15;
                        }
                        case START_OBJECT: {
                            ob.put(fieldName, (Object)this.deserialize(p, ctxt));
                            break block15;
                        }
                        case VALUE_STRING: {
                            ob.put(fieldName, (Object)p.getText());
                            break block15;
                        }
                        case VALUE_NULL: {
                            ob.put(fieldName, JSONObject.NULL);
                            break block15;
                        }
                        case VALUE_TRUE: {
                            ob.put(fieldName, (Object)Boolean.TRUE);
                            break block15;
                        }
                        case VALUE_FALSE: {
                            ob.put(fieldName, (Object)Boolean.FALSE);
                            break block15;
                        }
                        case VALUE_NUMBER_INT: {
                            ob.put(fieldName, (Object)p.getNumberValue());
                            break block15;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            ob.put(fieldName, (Object)p.getDecimalValue());
                            break block15;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            ob.put(fieldName, p.getEmbeddedObject());
                            break block15;
                        }
                    }
                }
                catch (JSONException e) {
                    throw ctxt.instantiationException(this.handledType(), (Throwable)e);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
            t = p.nextToken();
        }
        return ob;
    }
}

