/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.plugins.im.AuthenticationHolder;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionListener;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessage;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMPresence;
import hudson.plugins.im.bot.Bot;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.v2.IRCChannel;
import hudson.plugins.ircbot.v2.IRCColorizer;
import hudson.plugins.ircbot.v2.IRCPrivateChat;
import hudson.plugins.ircbot.v2.PircListener;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.pircbotx.Channel;
import org.pircbotx.Configuration;
import org.pircbotx.PircBotX;
import org.pircbotx.ProxySocketFactory;
import org.pircbotx.UtilSSLSocketFactory;
import org.pircbotx.cap.CapHandler;
import org.pircbotx.cap.SASLCapHandler;
import org.pircbotx.delay.Delay;
import org.pircbotx.delay.StaticReadonlyDelay;
import org.pircbotx.exception.NotReadyException;
import org.pircbotx.hooks.Listener;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.events.ConnectEvent;

public class IRCConnection
implements IMConnection,
PircListener.JoinListener,
PircListener.InviteListener,
PircListener.PartListener {
    private static final Logger LOGGER = Logger.getLogger(IRCConnection.class.getName());
    private final IrcPublisher.DescriptorImpl descriptor;
    private final AuthenticationHolder authentication;
    private Thread botThread;
    private final Configuration.Builder cfg;
    private volatile PircBotX pircConnection;
    private final PircListener listener;
    private List<IMMessageTarget> groupChats;
    private final Map<String, Bot> bots = new HashMap<String, Bot>();
    private final Map<String, Bot> privateChats = new HashMap<String, Bot>();

    @SuppressFBWarnings(value={"UR_UNINIT_READ"}, justification="UR_UNINIT_READ: TODO: this is probably a genuine problem but I don't know why; MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR: Need ecosystem change to separate IRCConnection construction from PircListener connection")
    public IRCConnection(IrcPublisher.DescriptorImpl descriptor, AuthenticationHolder authentication) {
        String nickServPassword;
        String password;
        Configuration.Builder config = new Configuration.Builder();
        this.descriptor = descriptor;
        this.authentication = authentication;
        this.groupChats = descriptor.getDefaultTargets() != null ? descriptor.getDefaultTargets() : Collections.emptyList();
        config.setServerHostname(descriptor.getHost());
        config.setServerPort(descriptor.getPort());
        if (this.descriptor.isSasl()) {
            LOGGER.info("Enabling SASL");
            config.setCapEnabled(true);
            config.addCapHandler((CapHandler)new SASLCapHandler(this.descriptor.getLogin(), this.descriptor.getSecretPassword().getPlainText()));
        } else if (this.descriptor.getSecretPassword() != null && (password = Util.fixEmpty((String)this.descriptor.getSecretPassword().getPlainText())) != null) {
            config.setServerPassword(password);
        }
        if (this.descriptor.getSecretNickServPassword() != null && (nickServPassword = Util.fixEmpty((String)this.descriptor.getSecretNickServPassword().getPlainText())) != null) {
            config.setNickservPassword(nickServPassword);
        }
        String socksHost = Util.fixEmpty((String)this.descriptor.getSocksHost());
        SocketFactory sf = this.descriptor.isSsl() ? (this.descriptor.isTrustAllCertificates() ? new UtilSSLSocketFactory().trustAllCertificates() : SSLSocketFactory.getDefault()) : (socksHost != null && this.descriptor.getSocksPort() > 0 ? new ProxySocketFactory(Proxy.Type.SOCKS, this.descriptor.getSocksHost(), this.descriptor.getSocksPort()) : SocketFactory.getDefault());
        config.setSocketFactory(sf);
        config.setLogin(this.descriptor.getLogin());
        config.setName(this.descriptor.getNick());
        config.setMessageDelay((Delay)new StaticReadonlyDelay((long)this.descriptor.getMessageRate().intValue()));
        config.setEncoding(Charset.forName(this.descriptor.getCharset()));
        this.listener = new PircListener(this.pircConnection, this.descriptor.getNick());
        this.listener.addJoinListener(this);
        this.listener.addInviteListener(this);
        this.listener.addPartListener(this);
        this.listener.addMessageListener(this.descriptor.getNick(), PircListener.CHAT_ESTABLISHER, new ChatEstablishedListener());
        config.addListener((Listener)this.listener);
        config.setAutoNickChange(false);
        config.setAutoReconnect(false);
        this.cfg = config;
    }

    public void close() {
        this.listener.explicitDisconnect = true;
        if (this.botThread != null) {
            this.botThread.interrupt();
        }
    }

    public boolean isConnected() {
        return this.pircConnection != null && this.pircConnection.isConnected();
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Commented below, no idea how to solve")
    public boolean connect() {
        try {
            LOGGER.info(String.format("Connecting to %s:%s as %s using charset %s", this.descriptor.getHost(), this.descriptor.getPort(), this.descriptor.getNick(), this.descriptor.getCharset()));
            if (this.botThread != null) {
                this.botThread.interrupt();
            }
            final CountDownLatch connectLatch = new CountDownLatch(1);
            ListenerAdapter connectListener = new ListenerAdapter(){

                public void onConnect(ConnectEvent event) throws Exception {
                    connectLatch.countDown();
                    LOGGER.info("connected to IRC");
                }
            };
            this.cfg.addListener((Listener)connectListener);
            this.botThread = new Thread("IRC Bot"){

                @Override
                public void run() {
                    IRCConnection.this.pircConnection = new PircBotX(IRCConnection.this.cfg.buildConfiguration());
                    try {
                        IRCConnection.this.pircConnection.startBot();
                    }
                    catch (Exception e) {
                        LOGGER.warning("Error connecting to irc: " + String.valueOf(e));
                    }
                }
            };
            this.botThread.start();
            try {
                boolean connected = connectLatch.await(2L, TimeUnit.MINUTES);
                if (!connected) {
                    LOGGER.warning("Time out waiting for connecting to irc");
                    this.close();
                    return false;
                }
            }
            catch (InterruptedException e) {
                LOGGER.warning("Interrupted waiting for connecting to irc: " + String.valueOf(e));
                Thread.currentThread().interrupt();
            }
            this.pircConnection.getConfiguration().getListenerManager().removeListener((Listener)connectListener);
            this.joinGroupChats();
            return this.pircConnection.isConnected();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Error connecting to irc", e);
            return false;
        }
    }

    private void joinGroupChats() {
        long startTime = System.currentTimeMillis();
        long timeout = TimeUnit.MINUTES.toMillis(2L);
        Exception ex = null;
        while (System.currentTimeMillis() - startTime < timeout) {
            for (IMMessageTarget groupChat : this.groupChats) {
                try {
                    this.joinGroupChat(groupChat);
                }
                catch (Exception e) {
                    LOGGER.warning("Unable to connect to channel '" + String.valueOf(groupChat) + "'.\nMessage: " + ExceptionHelper.dump((Throwable)e));
                    ex = e;
                    break;
                }
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.areWeConnectedToAllChannels()) break;
            LOGGER.info("Still not connected to all channels. Retrying.");
        }
        if (ex == null && !this.areWeConnectedToAllChannels()) {
            LOGGER.warning("Still not connected to all channels after " + timeout + " minutes. Giving up.");
        }
    }

    private boolean areWeConnectedToAllChannels() {
        Set groupChatNames = this.groupChats.stream().map(GroupChatIMMessageTarget.class::cast).map(GroupChatIMMessageTarget::getName).collect(Collectors.toSet());
        Set connectedToChannels = this.pircConnection.getUserChannelDao().getAllChannels().stream().map(Channel::getName).collect(Collectors.toSet());
        return groupChatNames.equals(connectedToChannels);
    }

    private GroupChatIMMessageTarget getGroupChatForChannelName(String channelName) {
        for (IMMessageTarget messageTarget : this.groupChats) {
            GroupChatIMMessageTarget groupChat;
            if (!(messageTarget instanceof GroupChatIMMessageTarget) || !(groupChat = (GroupChatIMMessageTarget)messageTarget).getName().equals(channelName)) continue;
            return groupChat;
        }
        return null;
    }

    private void joinGroupChat(IMMessageTarget groupChat) {
        if (!(groupChat instanceof GroupChatIMMessageTarget)) {
            LOGGER.warning(String.valueOf(groupChat) + " is no channel. Cannot join.");
            return;
        }
        GroupChatIMMessageTarget channel = (GroupChatIMMessageTarget)groupChat;
        LOGGER.info("Trying to join channel " + channel.getName());
        if (channel.hasPassword()) {
            this.pircConnection.sendIRC().joinChannel(channel.getName(), channel.getSecretPassword().getPlainText());
        } else {
            this.pircConnection.sendIRC().joinChannel(channel.getName());
        }
    }

    @Override
    public void channelJoined(String channelName) {
        GroupChatIMMessageTarget groupChat = this.getGroupChatForChannelName(channelName);
        if (groupChat == null) {
            LOGGER.log(Level.INFO, "Joined to channel {0} but I don't seem to belong here", channelName);
            return;
        }
        Bot bot = new Bot((IMChat)new IRCChannel(channelName, this, this.listener, !groupChat.isNotificationOnly()), this.descriptor.getNick(), this.descriptor.getHost(), this.descriptor.getCommandPrefix(), this.authentication);
        this.bots.put(channelName, bot);
        LOGGER.log(Level.INFO, "Joined channel {0} and bot registered", channelName);
    }

    @Override
    public void inviteReceived(String channelName) {
        GroupChatIMMessageTarget groupChat = this.getGroupChatForChannelName(channelName);
        if (groupChat == null) {
            LOGGER.log(Level.INFO, "Invited to channel {0} but I don't seem to belong here", channelName);
            return;
        }
        LOGGER.log(Level.INFO, "Invited to join {0}", channelName);
        this.joinGroupChat((IMMessageTarget)groupChat);
    }

    @Override
    public void channelParted(String channelName) {
        GroupChatIMMessageTarget groupChat = this.getGroupChatForChannelName(channelName);
        if (groupChat == null) {
            LOGGER.log(Level.INFO, "I'm leaving {0} but I never seemed to belong there in the first place", channelName);
            return;
        }
        if (this.bots.containsKey(channelName)) {
            Bot bot = this.bots.remove(channelName);
            bot.shutdown();
            LOGGER.log(Level.INFO, "I have left {0}", channelName);
        } else {
            LOGGER.log(Level.INFO, "No bot ever registered for {0}", channelName);
        }
    }

    public void addConnectionListener(IMConnectionListener listener) {
        this.listener.addConnectionListener(listener);
    }

    public void removeConnectionListener(IMConnectionListener listener) {
        this.listener.removeConnectionListener(listener);
    }

    public void send(IMMessageTarget target, String text) throws IMException {
        this.send(target.toString(), text);
    }

    public void send(String target, String text) throws IMException {
        String[] lines;
        Channel channel = this.pircConnection.getUserChannelDao().getChannel(target);
        boolean useColors = this.descriptor.isUseColors();
        if (useColors) {
            String mode;
            try {
                mode = channel.getMode();
            }
            catch (NotReadyException e) {
                throw new IMException((Exception)((Object)e));
            }
            if (mode.contains("c")) {
                LOGGER.warning("Bot is configured to use colors, but channel " + target + " disallows colors!");
                useColors = false;
            }
        }
        for (String line : lines = text.split("\\r?\\n|\\r")) {
            if (useColors) {
                line = IRCColorizer.colorize(line);
            }
            if (this.descriptor.isUseNotice()) {
                this.pircConnection.sendIRC().notice(target, line);
                continue;
            }
            this.pircConnection.sendIRC().message(target, line);
        }
    }

    public void setPresence(IMPresence presence, String statusMessage) throws IMException {
        if (presence.ordinal() >= IMPresence.OCCUPIED.ordinal()) {
            if (statusMessage == null || statusMessage.trim().length() == 0) {
                statusMessage = "away";
            }
            this.pircConnection.sendRaw().rawLineNow("AWAY " + statusMessage);
        } else {
            this.pircConnection.sendRaw().rawLineNow("AWAY");
        }
    }

    private class ChatEstablishedListener
    implements IMMessageListener {
        private ChatEstablishedListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(IMMessage message) {
            if (IRCConnection.this.descriptor.isDisallowPrivateChat()) {
                return;
            }
            if (!message.getTo().equals(IRCConnection.this.descriptor.getNick())) {
                throw new IllegalStateException("Intercepted message to '" + message.getTo() + "'. That shouldn't happen!");
            }
            Map<String, Bot> map = IRCConnection.this.privateChats;
            synchronized (map) {
                if (IRCConnection.this.privateChats.containsKey(message.getFrom())) {
                    return;
                }
                IRCPrivateChat chat = new IRCPrivateChat(IRCConnection.this, IRCConnection.this.listener, IRCConnection.this.descriptor.getUserName(), message.getFrom());
                Bot bot = new Bot((IMChat)chat, IRCConnection.this.descriptor.getNick(), IRCConnection.this.descriptor.getHost(), IRCConnection.this.descriptor.getCommandPrefix(), IRCConnection.this.authentication, false);
                IRCConnection.this.privateChats.put(message.getFrom(), bot);
                bot.onMessage(message);
            }
        }
    }
}

