/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import hudson.model.ResultTrend;
import java.lang.invoke.StringConcatFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IRCColorizer {
    private static final Pattern TEST_CLASS_PATTERN = Pattern.compile(".*test.*", 2);

    public static String colorize(String message) {
        Matcher m;
        if (message.contains("Starting ")) {
            return message;
        }
        String line = IRCColorizer.colorForBuildResult(message);
        if (line.equals(message) && (m = TEST_CLASS_PATTERN.matcher(message)).matches()) {
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0002\u0001", "\u0002\u000313"}, (String)line);
        }
        return line;
    }

    private static String colorForBuildResult(String line) {
        for (ResultTrend result : ResultTrend.values()) {
            String color;
            String keyword = result.getID();
            int index = line.indexOf(keyword);
            if (index == -1) continue;
            switch (result) {
                case FIXED: {
                    color = "\u0002\u001f\u000309";
                    break;
                }
                case SUCCESS: {
                    color = "\u0002\u000309";
                    break;
                }
                case FAILURE: {
                    color = "\u0002\u001f\u000304";
                    break;
                }
                case STILL_FAILING: {
                    color = "\u0002\u000304";
                    break;
                }
                case UNSTABLE: {
                    color = "\u0002\u001f\u000305";
                    break;
                }
                case STILL_UNSTABLE: {
                    color = "\u0002\u000305";
                    break;
                }
                case NOW_UNSTABLE: {
                    color = "\u0002\u000313";
                    break;
                }
                case ABORTED: {
                    color = "\u0002\u000315";
                    break;
                }
                default: {
                    return line;
                }
            }
            return line.substring(0, index) + color + keyword + "\u000f" + line.substring(index + keyword.length(), line.length());
        }
        return line;
    }
}

