/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.output;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.PircBotX;

public class OutputIRC {
    @NonNull
    protected final PircBotX bot;

    public void joinChannel(String channel) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)channel), (String)"Channel '%s' is blank", (Object)channel);
        this.bot.sendRaw().rawLine("JOIN " + channel);
    }

    public void joinChannel(String channel, String key) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)channel), (String)"Channel '%s' is blank", (Object)channel);
        Preconditions.checkNotNull((Object)key, (String)"Key for channel %s cannot be null", (Object)channel);
        this.bot.sendRaw().rawLine("JOIN " + channel + " " + key, "JOIN " + channel + " XXXXXXXX");
    }

    public void quitServer() {
        this.quitServer("");
    }

    public void quitServer(String reason) {
        Preconditions.checkNotNull((Object)reason, (Object)"Reason cannot be null");
        this.bot.sendRaw().rawLineNow("QUIT :" + reason);
    }

    public void ctcpCommand(String target, String command) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)target), (String)"Target '%s' is blank", (Object)target, (Object)command);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)command), (String)"CTCP command '%s' is blank", (Object)command, (Object)target);
        this.bot.sendRaw().rawLineSplit("PRIVMSG " + target + " :\u0001", command, "\u0001");
    }

    public void ctcpResponse(String target, String message) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)target), (String)"Target '%s' is blank", (Object)target);
        this.bot.sendRaw().rawLine("NOTICE " + target + " :\u0001" + message + "\u0001");
    }

    public void message(String target, String message) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)target), (String)"Target '%s' is blank", (Object)target);
        this.bot.sendRaw().rawLineSplit("PRIVMSG " + target + " :", message);
    }

    public void action(String target, String action) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)target), (String)"Target '%s' is blank", (Object)target);
        this.ctcpCommand(target, "ACTION " + action);
    }

    public void notice(String target, String notice) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)target), (String)"Target '%s' is blank", (Object)target);
        this.bot.sendRaw().rawLineSplit("NOTICE " + target + " :", notice);
    }

    public void changeNick(String newNick) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)newNick), (String)"Nick '%s' is blank", (Object)newNick);
        this.bot.sendRaw().rawLine("NICK " + newNick);
    }

    public void invite(String target, String channel) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)target), (String)"Nick '%s' is blank", (Object)target);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)channel), (String)"Channel '%s' is blank", (Object)channel);
        this.bot.sendRaw().rawLine("INVITE " + target + " :" + channel);
    }

    public void listChannels() {
        this.listChannels("");
    }

    public void listChannels(String parameters) {
        Preconditions.checkNotNull((Object)parameters, (Object)"Parameters cannot be null");
        if (!this.bot.getInputParser().isChannelListRunning()) {
            this.bot.sendRaw().rawLine("LIST " + parameters);
        }
    }

    public void identify(String password) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"Password '%s' is blank", (Object)password);
        this.bot.sendRaw().rawLine("NICKSERV IDENTIFY " + password, "NICKSERV IDENTIFY XXXXXXXX");
    }

    public void mode(String target, String mode) {
        this.bot.sendRaw().rawLine("MODE " + target + " " + mode);
    }

    public void whois(String target) {
        this.bot.sendRaw().rawLine("WHOIS " + target);
    }

    public void whoisDetail(String target) {
        this.bot.sendRaw().rawLine("WHOIS " + target + " " + target);
    }

    public void oper(String username, String password) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username), (String)"Username '%s' is blank", (Object)password);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)password), (String)"Password '%s' is blank", (Object)password);
        this.bot.sendRaw().rawLine("OPER " + username + " " + password, "OPER " + username + " XXXXXXXX");
    }

    public OutputIRC(@NonNull PircBotX bot) {
        if (bot == null) {
            throw new NullPointerException("bot is marked non-null but is null");
        }
        this.bot = bot;
    }
}

