/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.managers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.Listener;
import org.pircbotx.hooks.managers.AbstractListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedListenerManager
extends AbstractListenerManager {
    private static final Logger log = LoggerFactory.getLogger(ThreadedListenerManager.class);
    protected static final AtomicInteger MANAGER_COUNT = new AtomicInteger();
    protected final int managerNumber;
    protected ExecutorService pool;
    protected Set<Listener> listeners = ConcurrentHashMap.newKeySet();
    protected final Multimap<PircBotX, ManagedFutureTask> runningListeners = LinkedListMultimap.create();

    public ThreadedListenerManager() {
        this.managerNumber = MANAGER_COUNT.getAndIncrement();
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("listenerPool" + this.managerNumber + "-thread%d").daemon(true).build();
        ThreadPoolExecutor defaultPool = (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)factory);
        defaultPool.allowCoreThreadTimeOut(true);
        this.pool = defaultPool;
    }

    public ThreadedListenerManager(ExecutorService pool) {
        this.managerNumber = MANAGER_COUNT.getAndIncrement();
        this.pool = pool;
    }

    @Override
    public void addListener(Listener listener) {
        this.getListenersReal().add(listener);
    }

    @Override
    public boolean removeListener(Listener listener) {
        return this.getListenersReal().remove(listener);
    }

    @Override
    public ImmutableSet<Listener> getListeners() {
        return ImmutableSet.copyOf(this.getListenersReal());
    }

    protected Set<Listener> getListenersReal() {
        return this.listeners;
    }

    @Override
    public boolean listenerExists(Listener listener) {
        return this.getListeners().contains((Object)listener);
    }

    @Override
    public void onEvent(Event event) {
        super.onEvent(event);
        for (Listener curListener : this.getListenersReal()) {
            this.submitEvent(this.pool, curListener, event);
        }
    }

    protected void submitEvent(ExecutorService pool, Listener listener, Event event) {
        pool.execute(new ManagedFutureTask(listener, event, new AbstractListenerManager.ExecuteListenerRunnable(this, listener, event)));
    }

    public ExecutorService shutdown() {
        this.pool.shutdown();
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(PircBotX bot) {
        ArrayList remainingTasks;
        Multimap<PircBotX, ManagedFutureTask> multimap = this.runningListeners;
        synchronized (multimap) {
            remainingTasks = Lists.newArrayList((Iterable)this.runningListeners.get((Object)bot));
        }
        for (ManagedFutureTask curFuture : remainingTasks) {
            try {
                log.debug("Waiting for listener " + curFuture.getListener() + " to execute event " + curFuture.getEvent());
                curFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot shutdown listener " + curFuture.getListener() + " executing event " + curFuture.getEvent(), e);
            }
        }
    }

    public class ManagedFutureTask
    extends FutureTask<Void> {
        protected final Listener listener;
        protected final Event event;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ManagedFutureTask(Listener listener, Event event, Runnable run) {
            super(run, null);
            this.listener = listener;
            this.event = event;
            if (event.getBot() != null) {
                Multimap<PircBotX, ManagedFutureTask> multimap = ThreadedListenerManager.this.runningListeners;
                synchronized (multimap) {
                    ThreadedListenerManager.this.runningListeners.put(event.getBot(), (Object)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            if (this.event.getBot() != null) {
                Multimap<PircBotX, ManagedFutureTask> multimap = ThreadedListenerManager.this.runningListeners;
                synchronized (multimap) {
                    ThreadedListenerManager.this.runningListeners.remove(this.event.getBot(), (Object)this);
                }
            }
        }

        public Listener getListener() {
            return this.listener;
        }

        public Event getEvent() {
            return this.event;
        }
    }
}

