/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.managers;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.Listener;
import org.pircbotx.hooks.managers.AbstractListenerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequentialListenerManager
extends AbstractListenerManager {
    private static final Logger log = LoggerFactory.getLogger(SequentialListenerManager.class);
    protected final LinkedList<Listener> listeners = new LinkedList();
    protected final LinkedList<ListenerExecutor> listenerExecutors = new LinkedList();
    private final ThreadFactory sequentialThreadFactory;
    private final Executor executorPool;

    @Override
    public void onEvent(Event event) {
        super.onEvent(event);
        for (ListenerExecutor executor : this.listenerExecutors) {
            executor.handleEvent(event);
        }
    }

    @Override
    public void addListener(Listener listener) {
        this.addListenerPooled(listener);
    }

    public SequentialListenerManager addListenerInline(Listener listener) {
        this.addListenerExecutor(listener, new InlineListenerExecutor(this, listener));
        return this;
    }

    public SequentialListenerManager addListenerPooled(Listener listener) {
        this.addListenerExecutor(listener, new PooledListenerExecutor(this, listener, this.executorPool));
        return this;
    }

    public SequentialListenerManager addListenerPooled(Listener listener, Executor suppliedPool) {
        this.addListenerExecutor(listener, new PooledListenerExecutor(this, listener, suppliedPool));
        return this;
    }

    public SequentialListenerManager addListenerSequential(Listener listener) {
        this.addListenerExecutor(listener, new SequentialListenerExecutor(this, listener));
        return this;
    }

    public SequentialListenerManager addListenerExecutor(Listener listener, ListenerExecutor executor) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("Cannot add listener twice " + listener);
        }
        this.listeners.add(listener);
        this.listenerExecutors.add(executor);
        return this;
    }

    public SequentialListenerManager addListenerExecutor(int index, Listener listener, ListenerExecutor executor) {
        if (this.listeners.contains(listener)) {
            throw new IllegalArgumentException("Cannot add listener twice " + listener);
        }
        this.listeners.add(index, listener);
        this.listenerExecutors.add(index, executor);
        return this;
    }

    public SequentialListenerManager updateExecutor(Listener listener, ListenerExecutor executor) {
        if (!this.listenerExists(listener)) {
            throw new RuntimeException("Listener " + listener + " does not exist in this manager");
        }
        int index = this.listeners.indexOf(listener);
        this.listenerExecutors.set(index, executor);
        return this;
    }

    public SequentialListenerManager updateExecutorAllInline() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener curListener = this.listeners.get(i);
            this.listenerExecutors.set(i, new InlineListenerExecutor(this, curListener));
        }
        return this;
    }

    @Override
    public boolean removeListener(Listener listener) {
        if (!this.listeners.contains(listener)) {
            return false;
        }
        int index = this.listeners.indexOf(listener);
        this.listeners.remove(index);
        this.listenerExecutors.remove(index);
        return true;
    }

    @Override
    public boolean listenerExists(Listener listener) {
        return this.listeners.contains(listener);
    }

    @Override
    public ImmutableSet<Listener> getListeners() {
        return ImmutableSet.copyOf(this.listeners);
    }

    @Override
    public void shutdown(PircBotX bot) {
        if (this.executorPool instanceof ExecutorService) {
            ((ExecutorService)this.executorPool).shutdown();
        }
    }

    public static SequentialListenerManager newDefault() {
        return SequentialListenerManager.builder().build();
    }

    SequentialListenerManager(ThreadFactory sequentialThreadFactory, Executor executorPool) {
        this.sequentialThreadFactory = sequentialThreadFactory;
        this.executorPool = executorPool;
    }

    public static SequentialListenerManagerBuilder builder() {
        return new SequentialListenerManagerBuilder();
    }

    public ThreadFactory getSequentialThreadFactory() {
        return this.sequentialThreadFactory;
    }

    public Executor getExecutorPool() {
        return this.executorPool;
    }

    public static interface ListenerExecutor
    extends Closeable {
        public void handleEvent(Event var1);
    }

    public static class InlineListenerExecutor
    implements ListenerExecutor {
        protected final AbstractListenerManager listenerManager;
        protected final Listener wrappedListener;

        @Override
        public void handleEvent(Event event) {
            this.listenerManager.executeListener(this.wrappedListener, event);
        }

        @Override
        public void close() throws IOException {
        }

        public InlineListenerExecutor(AbstractListenerManager listenerManager, Listener wrappedListener) {
            this.listenerManager = listenerManager;
            this.wrappedListener = wrappedListener;
        }
    }

    public static class PooledListenerExecutor
    implements ListenerExecutor {
        protected final AbstractListenerManager listenerManager;
        protected final Listener wrappedListener;
        protected final Executor executor;

        @Override
        public void handleEvent(Event event) {
            this.executor.execute(new AbstractListenerManager.ExecuteListenerRunnable(this.listenerManager, this.wrappedListener, event));
        }

        @Override
        public void close() throws IOException {
            if (this.executor instanceof ExecutorService) {
                ((ExecutorService)this.executor).shutdown();
            }
        }

        public PooledListenerExecutor(AbstractListenerManager listenerManager, Listener wrappedListener, Executor executor) {
            this.listenerManager = listenerManager;
            this.wrappedListener = wrappedListener;
            this.executor = executor;
        }
    }

    public static class SequentialListenerExecutor
    extends PooledListenerExecutor {
        public SequentialListenerExecutor(SequentialListenerManager listenerManager, Listener wrappedListener) {
            super(listenerManager, wrappedListener, Executors.newSingleThreadExecutor(listenerManager.getSequentialThreadFactory()));
        }
    }

    public static class SequentialListenerManagerBuilder {
        private ThreadFactory sequentialThreadFactory;
        private Executor executorPool = Executors.newCachedThreadPool();

        public SequentialListenerManagerBuilder() {
            this.sequentialThreadFactory = Executors.defaultThreadFactory();
        }

        public SequentialListenerManagerBuilder sequentialThreadFactory(ThreadFactory sequentialThreadFactory) {
            this.sequentialThreadFactory = sequentialThreadFactory;
            return this;
        }

        public SequentialListenerManagerBuilder executorPool(Executor executorPool) {
            this.executorPool = executorPool;
            return this;
        }

        public SequentialListenerManager build() {
            return new SequentialListenerManager(this.sequentialThreadFactory, this.executorPool);
        }

        public String toString() {
            return "SequentialListenerManager.SequentialListenerManagerBuilder(sequentialThreadFactory=" + this.sequentialThreadFactory + ", executorPool=" + this.executorPool + ")";
        }
    }
}

