/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.Channel;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericCTCPEvent;
import org.pircbotx.hooks.types.GenericChannelEvent;

public class VersionEvent
extends Event
implements GenericCTCPEvent,
GenericChannelEvent {
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final Channel channel;

    public VersionEvent(PircBotX bot, @NonNull UserHostmask userHostmask, @NonNull User user, Channel channel) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        this.userHostmask = userHostmask;
        this.user = user;
        this.channel = channel;
    }

    @Override
    public void respond(String response) {
        this.getUser().send().ctcpResponse(response);
    }

    public String toString() {
        return "VersionEvent(userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", channel=" + this.getChannel() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionEvent)) {
            return false;
        }
        VersionEvent other = (VersionEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VersionEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        return result;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public Channel getChannel() {
        return this.channel;
    }
}

