/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.Channel;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericChannelUserEvent;
import org.pircbotx.hooks.types.GenericMessageEvent;

public class NoticeEvent
extends Event
implements GenericMessageEvent,
GenericChannelUserEvent {
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final Channel channel;
    protected final String channelSource;
    protected final String notice;
    protected final ImmutableMap<String, String> tags;

    public NoticeEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, Channel channel, @NonNull String channelSource, @NonNull String notice, ImmutableMap<String, String> tags) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (channelSource == null) {
            throw new NullPointerException("channelSource is marked non-null but is null");
        }
        if (notice == null) {
            throw new NullPointerException("notice is marked non-null but is null");
        }
        this.user = user;
        this.userHostmask = userHostmask;
        this.channel = channel;
        this.channelSource = channelSource;
        this.notice = notice;
        this.tags = tags;
    }

    @Override
    public String getMessage() {
        return this.notice;
    }

    @Override
    public void respond(String response) {
        this.respondWith(response);
    }

    @Override
    public void respondWith(String response) {
        if (this.getChannel() == null) {
            this.getUser().send().message(response);
        } else {
            ((PircBotX)this.getBot()).sendIRC().message(this.channelSource, response);
        }
    }

    public void respondChannel(String response) {
        if (this.getChannel() == null) {
            throw new RuntimeException("Event does not contain a channel");
        }
        ((PircBotX)this.getBot()).sendIRC().message(this.channelSource, response);
    }

    @Override
    public void respondPrivateMessage(String response) {
        this.getUser().send().message(response);
    }

    @Override
    public ImmutableMap<String, String> getV3Tags() {
        return this.tags;
    }

    public String getChannelSource() {
        return this.channelSource;
    }

    public String getNotice() {
        return this.notice;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "NoticeEvent(userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", channel=" + this.getChannel() + ", channelSource=" + this.getChannelSource() + ", notice=" + this.getNotice() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NoticeEvent)) {
            return false;
        }
        NoticeEvent other = (NoticeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        String this$channelSource = this.getChannelSource();
        String other$channelSource = other.getChannelSource();
        if (this$channelSource == null ? other$channelSource != null : !this$channelSource.equals(other$channelSource)) {
            return false;
        }
        String this$notice = this.getNotice();
        String other$notice = other.getNotice();
        if (this$notice == null ? other$notice != null : !this$notice.equals(other$notice)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NoticeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        String $channelSource = this.getChannelSource();
        result = result * 59 + ($channelSource == null ? 43 : $channelSource.hashCode());
        String $notice = this.getNotice();
        result = result * 59 + ($notice == null ? 43 : $notice.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }
}

