/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.Channel;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericChannelUserEvent;
import org.pircbotx.hooks.types.GenericMessageEvent;

public class MessageEvent
extends Event
implements GenericMessageEvent,
GenericChannelUserEvent {
    protected final Channel channel;
    protected final String channelSource;
    protected final UserHostmask userHostmask;
    protected final User user;
    protected final String message;
    protected final ImmutableMap<String, String> tags;

    public MessageEvent(PircBotX bot, @NonNull Channel channel, @NonNull String channelSource, @NonNull UserHostmask userHostmask, User user, @NonNull String message, ImmutableMap<String, String> tags) {
        super(bot);
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (channelSource == null) {
            throw new NullPointerException("channelSource is marked non-null but is null");
        }
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.channel = channel;
        this.channelSource = channelSource;
        this.userHostmask = userHostmask;
        this.user = user;
        this.message = message;
        this.tags = tags;
    }

    @Override
    public void respond(String response) {
        this.respondWith(this.getUser().getNick() + ": " + response);
    }

    @Override
    public void respondWith(String fullLine) {
        ((PircBotX)this.getBot()).sendIRC().message(this.channelSource, fullLine);
    }

    public void respondChannel(String response) {
        if (this.getChannel() == null) {
            throw new RuntimeException("Event does not contain a channel");
        }
        ((PircBotX)this.getBot()).sendIRC().message(this.channelSource, response);
    }

    @Override
    public void respondPrivateMessage(String response) {
        this.getUser().send().message(response);
    }

    @Override
    public ImmutableMap<String, String> getV3Tags() {
        return this.tags;
    }

    public String getChannelSource() {
        return this.channelSource;
    }

    public ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "MessageEvent(channel=" + this.getChannel() + ", channelSource=" + this.getChannelSource() + ", userHostmask=" + this.getUserHostmask() + ", user=" + this.getUser() + ", message=" + this.getMessage() + ", tags=" + this.getTags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEvent)) {
            return false;
        }
        MessageEvent other = (MessageEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Channel this$channel = this.getChannel();
        Channel other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        String this$channelSource = this.getChannelSource();
        String other$channelSource = other.getChannelSource();
        if (this$channelSource == null ? other$channelSource != null : !this$channelSource.equals(other$channelSource)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        ImmutableMap<String, String> this$tags = this.getTags();
        ImmutableMap<String, String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !this$tags.equals(other$tags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MessageEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Channel $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        String $channelSource = this.getChannelSource();
        result = result * 59 + ($channelSource == null ? 43 : $channelSource.hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        ImmutableMap<String, String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        return result;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

