/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks.events;

import java.io.IOException;
import java.net.InetAddress;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.dcc.ReceiveChat;
import org.pircbotx.hooks.Event;
import org.pircbotx.hooks.types.GenericDCCEvent;

public class IncomingChatRequestEvent
extends Event
implements GenericDCCEvent {
    protected final User user;
    protected final UserHostmask userHostmask;
    protected final InetAddress address;
    protected final int port;
    protected final String token;
    protected final boolean passive;

    public IncomingChatRequestEvent(PircBotX bot, @NonNull UserHostmask userHostmask, User user, @NonNull InetAddress address, int port, String token, boolean passive) {
        super(bot);
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.user = user;
        this.userHostmask = userHostmask;
        this.address = address;
        this.port = port;
        this.token = token;
        this.passive = passive;
    }

    public ReceiveChat accept() throws IOException {
        return ((PircBotX)this.getBot()).getDccHandler().acceptChatRequest(this);
    }

    @Deprecated
    public InetAddress getChatAddress() {
        return this.getAddress();
    }

    @Deprecated
    public int getChatPort() {
        return this.getPort();
    }

    @Deprecated
    public String getChatToken() {
        return this.getToken();
    }

    @Override
    public void respond(String response) {
        this.getUser().send().message(response);
    }

    public String toString() {
        return "IncomingChatRequestEvent(user=" + this.getUser() + ", userHostmask=" + this.getUserHostmask() + ", address=" + this.getAddress() + ", port=" + this.getPort() + ", token=" + this.getToken() + ", passive=" + this.isPassive() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncomingChatRequestEvent)) {
            return false;
        }
        IncomingChatRequestEvent other = (IncomingChatRequestEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.isPassive() != other.isPassive()) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        UserHostmask this$userHostmask = this.getUserHostmask();
        UserHostmask other$userHostmask = other.getUserHostmask();
        if (this$userHostmask == null ? other$userHostmask != null : !((Object)this$userHostmask).equals(other$userHostmask)) {
            return false;
        }
        InetAddress this$address = this.getAddress();
        InetAddress other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof IncomingChatRequestEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        result = result * 59 + (this.isPassive() ? 79 : 97);
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        UserHostmask $userHostmask = this.getUserHostmask();
        result = result * 59 + ($userHostmask == null ? 43 : ((Object)$userHostmask).hashCode());
        InetAddress $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Override
    @Nullable
    public User getUser() {
        return this.user;
    }

    @Override
    public UserHostmask getUserHostmask() {
        return this.userHostmask;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public boolean isPassive() {
        return this.passive;
    }
}

