/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks;

import com.google.common.collect.ComparisonChain;
import java.util.concurrent.atomic.AtomicLong;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.types.GenericEvent;

public abstract class Event
implements GenericEvent {
    protected static final AtomicLong EVENT_COUNTER = new AtomicLong();
    protected final long timestamp = System.currentTimeMillis();
    protected final PircBotX bot;
    protected final long id;

    public Event(PircBotX bot) {
        this.bot = bot;
        this.id = EVENT_COUNTER.getAndIncrement();
    }

    @Override
    public abstract void respond(String var1);

    @Override
    public int compareTo(Event other) {
        ComparisonChain comparison = ComparisonChain.start().compare(this.getTimestamp(), other.getTimestamp()).compare(this.getId(), other.getId());
        if (this.bot != null && other.getBot() != null) {
            comparison.compare(this.bot.getBotId(), ((PircBotX)other.getBot()).getBotId());
        }
        return comparison.result();
    }

    @Override
    public <T extends PircBotX> T getBot() {
        return (T)this.bot;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Object this$bot = this.getBot();
        Object other$bot = other.getBot();
        return !(this$bot == null ? other$bot != null : !this$bot.equals(other$bot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        Object $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        return result;
    }
}

