/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.hooks;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pircbotx.Configuration;
import org.pircbotx.PircBotX;
import org.pircbotx.UserHostmask;
import org.pircbotx.Utils;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.events.FingerEvent;
import org.pircbotx.hooks.events.PingEvent;
import org.pircbotx.hooks.events.ServerPingEvent;
import org.pircbotx.hooks.events.TimeEvent;
import org.pircbotx.hooks.events.VersionEvent;
import org.pircbotx.hooks.types.GenericMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreHooks
extends ListenerAdapter {
    private static final Logger log = LoggerFactory.getLogger(CoreHooks.class);

    @Override
    public void onFinger(FingerEvent event) {
        event.getUser().send().ctcpResponse("FINGER " + ((PircBotX)event.getBot()).getConfiguration().getFinger());
    }

    @Override
    public void onPing(PingEvent event) {
        event.getUser().send().ctcpResponse("PING " + event.getPingValue());
    }

    @Override
    public void onServerPing(ServerPingEvent event) {
        ((PircBotX)event.getBot()).sendRaw().rawLine("PONG " + event.getResponse());
    }

    @Override
    public void onTime(TimeEvent event) {
        event.getUser().send().ctcpResponse("TIME " + new Date().toString());
    }

    @Override
    public void onVersion(VersionEvent event) {
        event.getUser().send().ctcpResponse("VERSION " + ((PircBotX)event.getBot()).getConfiguration().getVersion());
    }

    @Override
    public void onGenericMessage(GenericMessageEvent event) throws Exception {
        Configuration config = ((PircBotX)event.getBot()).getConfiguration();
        UserHostmask hostmask = event.getUserHostmask();
        if (config.getNickservOnSuccess() != null && StringUtils.containsIgnoreCase((CharSequence)hostmask.getHostmask(), (CharSequence)config.getNickservNick()) && StringUtils.containsIgnoreCase((CharSequence)event.getMessage(), (CharSequence)config.getNickservOnSuccess())) {
            log.info("Successfully identified to nickserv");
            Utils.setNickServIdentified(event.getBot());
            if (config.isNickservDelayJoin()) {
                for (Map.Entry channelEntry : config.getAutoJoinChannels().entrySet()) {
                    ((PircBotX)event.getBot()).sendIRC().joinChannel((String)channelEntry.getKey(), (String)channelEntry.getValue());
                }
            }
        }
    }
}

