/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.dcc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.UserHostmask;
import org.pircbotx.Utils;
import org.pircbotx.dcc.FileTransferStatus;
import org.pircbotx.dcc.ReceiveChat;
import org.pircbotx.dcc.ReceiveFileTransfer;
import org.pircbotx.dcc.SendChat;
import org.pircbotx.dcc.SendFileTransfer;
import org.pircbotx.exception.DccException;
import org.pircbotx.hooks.events.FileTransferCompleteEvent;
import org.pircbotx.hooks.events.IncomingChatRequestEvent;
import org.pircbotx.hooks.events.IncomingFileTransferEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccHandler
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DccHandler.class);
    protected static final Random TOKEN_RANDOM = new SecureRandom();
    protected static final int TOKEN_RANDOM_MAX = 20000;
    @NonNull
    protected final PircBotX bot;
    protected final Map<PendingRecieveFileTransfer, CountDownLatch> pendingReceiveTransfers = new HashMap<PendingRecieveFileTransfer, CountDownLatch>();
    protected final List<PendingSendFileTransfer> pendingSendTransfers = new ArrayList<PendingSendFileTransfer>();
    protected final Map<PendingSendFileTransferPassive, CountDownLatch> pendingSendPassiveTransfers = new HashMap<PendingSendFileTransferPassive, CountDownLatch>();
    protected final Map<PendingSendChatPassive, CountDownLatch> pendingSendPassiveChat = new HashMap<PendingSendChatPassive, CountDownLatch>();
    protected final ExecutorService activeReceiveTransfers = Executors.newCachedThreadPool();
    protected final ExecutorService activeSendTransfers = Executors.newCachedThreadPool();
    protected boolean shuttingDown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processDcc(UserHostmask userHostmask, User user, String request) throws IOException {
        List<String> requestParts = DccHandler.tokenizeDccRequest(request);
        String type = requestParts.get(1);
        if (type.equals("SEND")) {
            String rawFilename = requestParts.get(2);
            String safeFilename = rawFilename.startsWith("\"") && rawFilename.endsWith("\"") ? rawFilename.substring(1, rawFilename.length() - 1) : rawFilename;
            InetAddress address = DccHandler.parseRawAddress(requestParts.get(3));
            int port = Integer.parseInt(requestParts.get(4));
            long size = Long.parseLong(Utils.tryGetIndex(requestParts, 5, "-1"));
            String transferToken = Utils.tryGetIndex(requestParts, 6, null);
            if (transferToken != null) {
                Map<PendingSendFileTransferPassive, CountDownLatch> map = this.pendingSendPassiveTransfers;
                synchronized (map) {
                    Iterator<Map.Entry<PendingSendFileTransferPassive, CountDownLatch>> pendingItr = this.pendingSendPassiveTransfers.entrySet().iterator();
                    while (pendingItr.hasNext()) {
                        Map.Entry<PendingSendFileTransferPassive, CountDownLatch> curEntry = pendingItr.next();
                        PendingSendFileTransferPassive transfer = curEntry.getKey();
                        if (transfer.getUser() != user || !transfer.getFilename().equals(rawFilename) || !transfer.getTransferToken().equals(transferToken)) continue;
                        transfer.setReceiverAddress(address);
                        transfer.setReceiverPort(port);
                        log.debug("Passive send file transfer of file {} to user {} accepted at address {} and port {}", new Object[]{transfer.getFilename(), transfer.getUser().getNick(), address, port});
                        curEntry.getValue().countDown();
                        pendingItr.remove();
                        return true;
                    }
                }
            }
            if (port == 0 || transferToken != null) {
                this.bot.getConfiguration().getListenerManager().onEvent(new IncomingFileTransferEvent(this.bot, userHostmask, user, rawFilename, safeFilename, address, port, size, transferToken, true));
            } else {
                this.bot.getConfiguration().getListenerManager().onEvent(new IncomingFileTransferEvent(this.bot, userHostmask, user, rawFilename, safeFilename, address, port, size, transferToken, false));
            }
        } else {
            if (type.equals("RESUME")) {
                Object transferToken;
                String filename = requestParts.get(2).replaceAll("\"", "");
                int port = Integer.parseInt(requestParts.get(3));
                long position = Long.parseLong(requestParts.get(4));
                if (port == 0) {
                    transferToken = requestParts.get(5);
                    Map<PendingSendFileTransferPassive, CountDownLatch> map = this.pendingSendPassiveTransfers;
                    synchronized (map) {
                        for (Map.Entry<PendingSendFileTransferPassive, CountDownLatch> curEntry : this.pendingSendPassiveTransfers.entrySet()) {
                            PendingSendFileTransferPassive transfer = curEntry.getKey();
                            if (transfer.getUser() != user || !transfer.getFilename().equals(filename) || !transfer.getTransferToken().equals(transferToken)) continue;
                            transfer.setPosition(position);
                            log.debug("Passive send file transfer of file {} to user {} set to position {}", new Object[]{transfer.getFilename(), transfer.getUser().getNick(), position});
                            this.bot.sendDCC().filePassiveResumeAccept(transfer.getUser().getNick(), transfer.getFilename(), transfer.getPosition(), transfer.getTransferToken());
                            return true;
                        }
                    }
                }
                transferToken = this.pendingSendTransfers;
                synchronized (transferToken) {
                    Iterator<PendingSendFileTransfer> pendingItr = this.pendingSendTransfers.iterator();
                    while (pendingItr.hasNext()) {
                        PendingSendFileTransfer transfer = pendingItr.next();
                        if (transfer.getUser() != user || !transfer.getFilename().equals(filename) || transfer.getPort() != port) continue;
                        transfer.setPosition(position);
                        log.debug("Send file transfer of file {} to user {} set to position {}", new Object[]{transfer.getFilename(), transfer.getUser().getNick(), position});
                        this.bot.sendDCC().fileResumeAccept(transfer.getUser().getNick(), transfer.getFilename(), transfer.getPort(), transfer.getPosition());
                        pendingItr.remove();
                        return true;
                    }
                }
                FileTransferStatus fileTransferStatus = new FileTransferStatus(0L, position);
                fileTransferStatus.exception = new DccException(DccException.Reason.UNKNOWN_FILE_TRANSFER_RESUME, user, "Transfer line: " + request);
                this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, fileTransferStatus, user, filename, null, port, fileTransferStatus.fileSize, false, true));
                return true;
            }
            if (type.equals("ACCEPT")) {
                String transferToken;
                int port;
                String filename = requestParts.get(2);
                long position = Long.parseLong(requestParts.get(4));
                if (requestParts.size() == 5) {
                    port = Integer.parseInt(requestParts.get(3));
                    transferToken = null;
                } else {
                    port = 0;
                    transferToken = requestParts.get(5);
                }
                Map<PendingRecieveFileTransfer, CountDownLatch> pendingItr = this.pendingReceiveTransfers;
                synchronized (pendingItr) {
                    Iterator<Map.Entry<PendingRecieveFileTransfer, CountDownLatch>> pendingItr2 = this.pendingReceiveTransfers.entrySet().iterator();
                    while (pendingItr2.hasNext()) {
                        Map.Entry<PendingRecieveFileTransfer, CountDownLatch> curEntry = pendingItr2.next();
                        IncomingFileTransferEvent transferEvent = curEntry.getKey().getEvent();
                        if (transferEvent.getUser() != user || !transferEvent.getRawFilename().equals(filename) || transferEvent.getPort() != port || transferEvent.getToken() != null && !transferEvent.getToken().equals(transferToken)) continue;
                        curEntry.getKey().setPosition(position);
                        log.debug("Receive file transfer of file {} to user {} set to position {}", new Object[]{transferEvent.getRawFilename(), transferEvent.getUser().getNick(), position});
                        curEntry.getValue().countDown();
                        pendingItr2.remove();
                        return true;
                    }
                }
            }
            if (type.equals("CHAT")) {
                InetAddress address = DccHandler.parseRawAddress(requestParts.get(3));
                int port = Integer.parseInt(requestParts.get(4));
                String chatToken = Utils.tryGetIndex(requestParts, 5, null);
                if (chatToken != null) {
                    Map<PendingSendChatPassive, CountDownLatch> map = this.pendingSendPassiveChat;
                    synchronized (map) {
                        Iterator<Map.Entry<PendingSendChatPassive, CountDownLatch>> pendingItr = this.pendingSendPassiveChat.entrySet().iterator();
                        while (pendingItr.hasNext()) {
                            Map.Entry<PendingSendChatPassive, CountDownLatch> curEntry = pendingItr.next();
                            PendingSendChatPassive pendingChat = curEntry.getKey();
                            log.trace("Current pending chat: {}", (Object)pendingChat);
                            if (pendingChat.getUser() != user || !pendingChat.getChatToken().equals(chatToken)) continue;
                            log.debug("Passive chat request to user {} accepted", (Object)user);
                            pendingChat.setReceiverAddress(address);
                            pendingChat.setReceiverPort(port);
                            curEntry.getValue().countDown();
                            pendingItr.remove();
                            return true;
                        }
                    }
                }
                if (port == 0 && chatToken != null) {
                    this.bot.getConfiguration().getListenerManager().onEvent(new IncomingChatRequestEvent(this.bot, userHostmask, user, address, port, chatToken, true));
                } else {
                    this.bot.getConfiguration().getListenerManager().onEvent(new IncomingChatRequestEvent(this.bot, userHostmask, user, address, port, chatToken, false));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public ReceiveChat acceptChatRequest(IncomingChatRequestEvent event) throws IOException {
        Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null");
        if (event.isPassive()) {
            ServerSocket serverSocket = this.createServerSocket(event.getUser());
            InetAddress publicAddress = this.getRealDccPublicAddress(serverSocket);
            this.bot.sendDCC().chatPassiveAccept(event.getUser().getNick(), publicAddress, serverSocket.getLocalPort(), event.getToken());
            log.debug("Sent DCC recieve chat accept to user {} ({}ms timeout) to passive connect on public address {}, local address {}", new Object[]{event.getUser().getNick(), this.bot.getConfiguration().getDccAcceptTimeout(), publicAddress, serverSocket.getLocalSocketAddress()});
            Socket userSocket = serverSocket.accept();
            serverSocket.close();
            return this.bot.getConfiguration().getBotFactory().createReceiveChat(this.bot, event.getUser(), userSocket);
        }
        InetAddress localAddress = this.getRealDccLocalAddress(event.getAddress());
        log.debug("Accepting DCC recieve chat from user {} at address {} port {} from local address {}", new Object[]{event.getUser().getNick(), event.getAddress(), event.getPort(), localAddress});
        return this.bot.getConfiguration().getBotFactory().createReceiveChat(this.bot, event.getUser(), new Socket(event.getAddress(), event.getPort(), localAddress, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiveFileTransfer acceptFileTransfer(IncomingFileTransferEvent event, File destination) throws IOException {
        Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null");
        Preconditions.checkNotNull((Object)destination, (Object)"Destination file cannot be null");
        CountDownLatch countdown = new CountDownLatch(1);
        PendingRecieveFileTransfer pendingTransfer = new PendingRecieveFileTransfer(event, event.getSafeFilename(), event.getFilesize());
        Map<PendingRecieveFileTransfer, CountDownLatch> map = this.pendingReceiveTransfers;
        synchronized (map) {
            this.pendingReceiveTransfers.put(pendingTransfer, countdown);
        }
        return this.acceptFileTransfer(pendingTransfer, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiveFileTransfer acceptFileTransferResume(IncomingFileTransferEvent event, File destination, long startPosition) throws IOException, InterruptedException, DccException {
        FileTransferStatus fileTransferStatus;
        Preconditions.checkNotNull((Object)event, (Object)"Event cannot be null");
        Preconditions.checkNotNull((Object)destination, (Object)"Destination file cannot be null");
        Preconditions.checkArgument((startPosition >= 0L ? 1 : 0) != 0, (String)"Start position %s must be positive", (long)startPosition);
        CountDownLatch countdown = new CountDownLatch(1);
        PendingRecieveFileTransfer pendingTransfer = new PendingRecieveFileTransfer(event, event.getSafeFilename(), event.getFilesize());
        Map<PendingRecieveFileTransfer, CountDownLatch> map = this.pendingReceiveTransfers;
        synchronized (map) {
            this.pendingReceiveTransfers.put(pendingTransfer, countdown);
        }
        if (event.isPassive()) {
            this.bot.sendDCC().filePassiveResumeRequest(event.getUser().getNick(), event.getRawFilename(), startPosition, event.getToken());
        } else {
            this.bot.sendDCC().fileResumeRequest(event.getUser().getNick(), event.getRawFilename(), event.getPort(), startPosition);
        }
        if (!countdown.await(this.bot.getConfiguration().getDccResumeAcceptTimeout(), TimeUnit.MILLISECONDS)) {
            fileTransferStatus = new FileTransferStatus(0L, startPosition);
            fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_TIMEOUT, event.getUser(), "Event: " + event);
            this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, fileTransferStatus, event.getUser(), event.getSafeFilename(), null, event.getPort(), event.getFilesize(), event.isPassive(), false));
            return null;
        }
        if (this.shuttingDown) {
            fileTransferStatus = new FileTransferStatus(0L, startPosition);
            fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_CANCELLED, event.getUser(), "Transfer " + event + " canceled due to bot shutting down");
            this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, fileTransferStatus, event.getUser(), event.getSafeFilename(), null, event.getPort(), event.getFilesize(), event.isPassive(), false));
            return null;
        }
        if (pendingTransfer.getPosition() != startPosition) {
            log.warn("User is resuming transfer at position {} instead of requested position {} for transfer {}. Defaulting to users position", new Object[]{pendingTransfer.getPosition(), startPosition, event});
        }
        return this.acceptFileTransfer(pendingTransfer, destination);
    }

    protected ReceiveFileTransfer acceptFileTransfer(PendingRecieveFileTransfer pendingTransfer, File destination) throws IOException {
        Preconditions.checkNotNull((Object)pendingTransfer.event, (Object)"Event cannot be null");
        Preconditions.checkNotNull((Object)destination, (Object)"Destination file cannot be null");
        Preconditions.checkArgument((pendingTransfer.position >= 0L ? 1 : 0) != 0, (String)"Start position %s must be positive", (long)pendingTransfer.position);
        ReceiveFileTransfer receiveFileTransfer = this.bot.getConfiguration().getBotFactory().createReceiveFileTransfer(this.bot, this, pendingTransfer, destination);
        this.activeSendTransfers.submit(() -> receiveFileTransfer.transfer());
        return receiveFileTransfer;
    }

    public SendChat sendChat(User receiver) throws IOException, InterruptedException {
        return this.sendChat(receiver, this.bot.getConfiguration().isDccPassiveRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendChat sendChat(User receiver, boolean passive) throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)receiver, (Object)"Receiver user cannot be null");
        int dccAcceptTimeout = this.bot.getConfiguration().getDccAcceptTimeout();
        if (passive) {
            String chatToken = Integer.toString(TOKEN_RANDOM.nextInt(20000));
            PendingSendChatPassive pendingChat = new PendingSendChatPassive(receiver, chatToken);
            CountDownLatch countdown = new CountDownLatch(1);
            Map<PendingSendChatPassive, CountDownLatch> map = this.pendingSendPassiveChat;
            synchronized (map) {
                this.pendingSendPassiveChat.put(pendingChat, countdown);
            }
            InetAddress publicAddress = this.getRealDccPublicAddress();
            this.bot.sendDCC().chatPassiveRequest(receiver.getNick(), publicAddress, chatToken);
            log.debug("Sent DCC send chat request to user {} ({}ms timeout) for passive connect info using public address {}", new Object[]{receiver.getNick(), this.bot.getConfiguration().getDccAcceptTimeout(), publicAddress});
            if (!countdown.await(dccAcceptTimeout, TimeUnit.MILLISECONDS)) {
                throw new DccException(DccException.Reason.CHAT_TIMEOUT, receiver, "");
            }
            if (this.shuttingDown) {
                throw new DccException(DccException.Reason.CHAT_CANCELLED, receiver, "");
            }
            Socket chatSocket = new Socket(pendingChat.getReceiverAddress(), pendingChat.getReceiverPort());
            return this.bot.getConfiguration().getBotFactory().createSendChat(this.bot, receiver, chatSocket);
        }
        ServerSocket serverSocket = this.createServerSocket(receiver);
        InetAddress publicAddress = this.getRealDccPublicAddress(serverSocket);
        this.bot.sendDCC().chatRequest(receiver.getNick(), publicAddress, serverSocket.getLocalPort());
        log.debug("Sent DCC send chat request to user {} ({}ms timeout) to connect on public address {}:{}, local address {}", new Object[]{receiver.getNick(), this.bot.getConfiguration().getDccAcceptTimeout(), publicAddress, serverSocket.getLocalPort(), serverSocket.getLocalSocketAddress()});
        Socket userSocket = serverSocket.accept();
        log.debug("Recieved connection");
        serverSocket.close();
        return this.bot.getConfiguration().getBotFactory().createSendChat(this.bot, receiver, userSocket);
    }

    public SendFileTransfer sendFile(File file, User receiver) throws IOException, DccException, InterruptedException {
        return this.sendFile(file, receiver, this.bot.getConfiguration().isDccPassiveRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendFileTransfer sendFile(File file, User receiver, boolean passive) throws IOException, DccException, InterruptedException {
        SendFileTransfer sendFileTransfer;
        Preconditions.checkNotNull((Object)file, (Object)"Source file cannot be null");
        Preconditions.checkNotNull((Object)receiver, (Object)"Receiver cannot be null");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File must exist");
        String safeFilename = file.getName();
        if (safeFilename.contains(" ")) {
            safeFilename = this.bot.getConfiguration().isDccFilenameQuotes() ? "\"" + safeFilename + "\"" : safeFilename.replace(" ", "_");
        }
        if (passive) {
            String transferToken = Integer.toString(TOKEN_RANDOM.nextInt(20000));
            CountDownLatch countdown = new CountDownLatch(1);
            PendingSendFileTransferPassive pendingPassiveTransfer = new PendingSendFileTransferPassive(receiver, safeFilename, file.length(), transferToken);
            Map<PendingSendFileTransferPassive, CountDownLatch> map = this.pendingSendPassiveTransfers;
            synchronized (map) {
                this.pendingSendPassiveTransfers.put(pendingPassiveTransfer, countdown);
            }
            InetAddress publicAddress = this.getRealDccPublicAddress();
            this.bot.sendDCC().filePassiveRequest(receiver.getNick(), safeFilename, publicAddress, file.length(), transferToken);
            log.debug("Sent DCC send file request to user {} ({}ms timeout) for passive connect info using public address {} for file {}", new Object[]{receiver.getNick(), this.bot.getConfiguration().getDccAcceptTimeout(), publicAddress, file.getAbsolutePath()});
            if (!countdown.await(this.bot.getConfiguration().getDccAcceptTimeout(), TimeUnit.MILLISECONDS)) {
                FileTransferStatus fileTransferStatus = new FileTransferStatus(0L, 0L);
                fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_TIMEOUT, receiver, "File: " + file.getAbsolutePath());
                this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, fileTransferStatus, receiver, safeFilename, publicAddress, 0, file.length(), passive, true));
                return null;
            }
            if (this.shuttingDown) {
                FileTransferStatus fileTransferStatus = new FileTransferStatus(0L, 0L);
                fileTransferStatus.exception = new DccException(DccException.Reason.FILE_TRANSFER_CANCELLED, receiver, "Transfer of file " + file.getAbsolutePath() + " canceled due to bot shutdown");
                this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, fileTransferStatus, receiver, safeFilename, publicAddress, 0, file.length(), passive, true));
                return null;
            }
            sendFileTransfer = this.bot.getConfiguration().getBotFactory().createSendFileTransfer(this.bot, this, pendingPassiveTransfer, file);
            this.activeSendTransfers.submit(() -> sendFileTransfer.transfer());
        } else {
            PendingSendFileTransfer pendingSendFileTransfer = new PendingSendFileTransfer(receiver, safeFilename, file.length(), this.createServerSocket(receiver));
            List<PendingSendFileTransfer> list = this.pendingSendTransfers;
            synchronized (list) {
                this.pendingSendTransfers.add(pendingSendFileTransfer);
            }
            sendFileTransfer = this.bot.getConfiguration().getBotFactory().createSendFileTransfer(this.bot, this, pendingSendFileTransfer, file);
            this.activeSendTransfers.submit(() -> sendFileTransfer.transfer());
        }
        return sendFileTransfer;
    }

    public InetAddress getRealDccLocalAddress(InetAddress destAddress) {
        InetAddress address = this.bot.getConfiguration().getDccLocalAddress();
        address = address != null && destAddress.getClass().equals(address.getClass()) ? address : this.bot.getConfiguration().getLocalAddress();
        address = address != null && destAddress.getClass().equals(address.getClass()) ? address : this.bot.getLocalAddress();
        address = address != null && destAddress.getClass().equals(address.getClass()) ? address : null;
        return address;
    }

    public InetAddress getRealDccLocalAddress() {
        InetAddress address = this.bot.getConfiguration().getDccLocalAddress();
        address = address != null ? address : this.bot.getConfiguration().getLocalAddress();
        address = address != null ? address : this.bot.getLocalAddress();
        return address;
    }

    public InetAddress getRealDccPublicAddress() {
        InetAddress address = this.bot.getConfiguration().getDccPublicAddress();
        return address != null ? address : this.getRealDccLocalAddress();
    }

    public InetAddress getRealDccPublicAddress(ServerSocket ss) {
        InetAddress address = this.bot.getConfiguration().getDccPublicAddress();
        return address != null ? address : ss.getInetAddress();
    }

    protected ServerSocket createServerSocket(User user) throws IOException, DccException {
        InetAddress address = this.getRealDccLocalAddress();
        ImmutableList<Integer> dccPorts = this.bot.getConfiguration().getDccPorts();
        ServerSocketChannel sc = ServerSocketChannel.open();
        if (dccPorts.isEmpty()) {
            sc.socket().bind(new InetSocketAddress(address, 0));
        } else {
            UnmodifiableIterator unmodifiableIterator = dccPorts.iterator();
            while (unmodifiableIterator.hasNext()) {
                int currentPort = (Integer)unmodifiableIterator.next();
                try {
                    sc.socket().bind(new InetSocketAddress(address, currentPort));
                    break;
                }
                catch (Exception e) {
                    log.debug("Failed to create server socket on port " + currentPort + ", trying next one", (Throwable)e);
                }
            }
            if (sc == null) {
                FileTransferStatus fileTransferStatus = new FileTransferStatus(0L, 0L);
                fileTransferStatus.exception = new DccException(DccException.Reason.DCC_PORTS_IN_USE, user, "Ports " + dccPorts + " are in use.");
                this.bot.getConfiguration().getListenerManager().onEvent(new FileTransferCompleteEvent(this.bot, fileTransferStatus, user, null, address, 0, 0L, false, true));
                return null;
            }
        }
        sc.socket().setSoTimeout(this.bot.getConfiguration().getDccAcceptTimeout());
        return sc.socket();
    }

    public Socket establishSocketConnection(PendingFileTransfer pendingFileTransfer) throws IOException {
        if (pendingFileTransfer instanceof PendingRecieveFileTransfer) {
            PendingRecieveFileTransfer fileTransfer = (PendingRecieveFileTransfer)pendingFileTransfer;
            if (fileTransfer.event.isPassive()) {
                ServerSocket serverSocket = this.createServerSocket(fileTransfer.event.getUser());
                this.bot.sendDCC().filePassiveAccept(fileTransfer.event.getUser().getNick(), fileTransfer.event.getRawFilename(), this.getRealDccPublicAddress(serverSocket), serverSocket.getLocalPort(), fileTransfer.event.getFilesize(), fileTransfer.event.getToken());
                Socket socket = serverSocket.accept();
                serverSocket.close();
                return socket;
            }
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.bind(new InetSocketAddress(this.getRealDccLocalAddress(fileTransfer.event.getAddress()), 0));
            socketChannel.connect(new InetSocketAddress(fileTransfer.event.getAddress(), fileTransfer.event.getPort()));
            return socketChannel.socket();
        }
        if (pendingFileTransfer instanceof PendingSendFileTransfer) {
            PendingSendFileTransfer fileTransfer = (PendingSendFileTransfer)pendingFileTransfer;
            InetAddress publicAddress = this.getRealDccPublicAddress(fileTransfer.serverSocket);
            log.debug("Sent DCC send file request to user {} ({}ms timeout) to connect on public address {}, local address {}, port {} for file {}", new Object[]{pendingFileTransfer.getUser().getNick(), this.bot.getConfiguration().getDccAcceptTimeout(), publicAddress, fileTransfer.serverSocket.getLocalSocketAddress(), fileTransfer.serverSocket.getLocalPort(), fileTransfer.filename});
            this.bot.sendDCC().fileRequest(fileTransfer.user.getNick(), fileTransfer.filename, publicAddress, fileTransfer.serverSocket.getLocalPort(), fileTransfer.fileSize);
            Socket socket = fileTransfer.serverSocket.accept();
            fileTransfer.serverSocket.close();
            return socket;
        }
        if (pendingFileTransfer instanceof PendingSendFileTransferPassive) {
            PendingSendFileTransferPassive fileTransfer = (PendingSendFileTransferPassive)pendingFileTransfer;
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.bind(new InetSocketAddress(this.getRealDccLocalAddress(fileTransfer.receiverAddress), 0));
            socketChannel.connect(new InetSocketAddress(fileTransfer.receiverAddress, fileTransfer.receiverPort));
            return socketChannel.socket();
        }
        throw new IOException("Failed to determine type of dcc transfer method");
    }

    protected static List<String> tokenizeDccRequest(String request) {
        int end;
        int quotesIndexBegin = request.indexOf(34);
        if (quotesIndexBegin == -1) {
            return Utils.tokenizeLine(request);
        }
        int quotesIndexEnd = request.lastIndexOf(34);
        ArrayList<String> stringParts = new ArrayList<String>();
        int pos = 0;
        while ((end = request.indexOf(32, pos)) >= 0) {
            if (pos >= quotesIndexBegin && end < quotesIndexEnd) {
                stringParts.add(request.substring(quotesIndexBegin, quotesIndexEnd + 1));
                pos = quotesIndexEnd + 2;
                continue;
            }
            stringParts.add(request.substring(pos, end));
            pos = end + 1;
            if (request.charAt(pos) != ':') continue;
            stringParts.add(request.substring(pos + 1));
            return stringParts;
        }
        stringParts.add(request.substring(pos));
        return stringParts;
    }

    @Override
    public void close() {
        this.shuttingDown = true;
        int pendingCount = this.pendingReceiveTransfers.values().size() + this.pendingSendPassiveTransfers.values().size();
        if (pendingCount > 0) {
            log.info("Terminating {} DCC transfers waiting to be accepted", (Object)pendingCount);
            for (CountDownLatch curCountdown : this.pendingReceiveTransfers.values()) {
                curCountdown.countDown();
            }
            for (CountDownLatch curCountdown : this.pendingSendPassiveTransfers.values()) {
                curCountdown.countDown();
            }
        }
        try {
            log.info("Terminating active DCC Receive transfers");
            this.activeReceiveTransfers.shutdown();
            this.activeReceiveTransfers.awaitTermination(10L, TimeUnit.SECONDS);
            log.info("Terminating active DCC Send transfers");
            this.activeSendTransfers.shutdown();
            this.activeSendTransfers.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Failed to gracefully close Send and Receive Transfers!", (Throwable)e);
        }
    }

    public static String addressToInteger(InetAddress address) {
        if (address instanceof Inet6Address) {
            return address.getHostAddress();
        }
        return new BigInteger(1, address.getAddress()).toString();
    }

    public static InetAddress parseRawAddress(String rawAddress) throws UnknownHostException {
        if (rawAddress.contains(":")) {
            return Inet6Address.getByName(rawAddress);
        }
        BigInteger bigIp = new BigInteger(rawAddress);
        byte[] addressBytes = bigIp.toByteArray();
        if (addressBytes.length == 5) {
            addressBytes = Arrays.copyOfRange(addressBytes, 1, 5);
        } else if (addressBytes.length < 4) {
            byte[] newAddressBytes = new byte[4];
            newAddressBytes[3] = addressBytes[0];
            newAddressBytes[2] = addressBytes.length > 1 ? addressBytes[1] : (byte)0;
            newAddressBytes[1] = addressBytes.length > 2 ? addressBytes[2] : (byte)0;
            newAddressBytes[0] = addressBytes.length > 3 ? addressBytes[3] : (byte)0;
            addressBytes = newAddressBytes;
        } else if (addressBytes.length == 17) {
            addressBytes = Arrays.copyOfRange(addressBytes, 1, 17);
        }
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException("Can't get InetAdrress version of int IP address " + rawAddress + " (bytes: " + Arrays.toString(addressBytes) + ")", ex);
        }
    }

    public static void main(String[] args) throws UnknownHostException {
        log.debug("IP: {}", (Object)DccHandler.parseRawAddress("134744072"));
    }

    public DccHandler(@NonNull PircBotX bot) {
        if (bot == null) {
            throw new NullPointerException("bot is marked non-null but is null");
        }
        this.bot = bot;
    }

    protected static class PendingSendFileTransferPassive
    extends PendingFileTransfer {
        protected final String filename;
        protected final String transferToken;
        protected InetAddress receiverAddress;
        protected int receiverPort;

        public PendingSendFileTransferPassive(User user, String filename, long fileSize, String transferToken) {
            super(user, filename, fileSize, true);
            this.filename = filename;
            this.transferToken = transferToken;
        }

        public static PendingSendFileTransferPassiveBuilder builder() {
            return new PendingSendFileTransferPassiveBuilder();
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        public String getTransferToken() {
            return this.transferToken;
        }

        public InetAddress getReceiverAddress() {
            return this.receiverAddress;
        }

        public int getReceiverPort() {
            return this.receiverPort;
        }

        public void setReceiverAddress(InetAddress receiverAddress) {
            this.receiverAddress = receiverAddress;
        }

        public void setReceiverPort(int receiverPort) {
            this.receiverPort = receiverPort;
        }

        @Override
        public String toString() {
            return "DccHandler.PendingSendFileTransferPassive(filename=" + this.getFilename() + ", transferToken=" + this.getTransferToken() + ", receiverAddress=" + this.getReceiverAddress() + ", receiverPort=" + this.getReceiverPort() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingSendFileTransferPassive)) {
                return false;
            }
            PendingSendFileTransferPassive other = (PendingSendFileTransferPassive)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReceiverPort() != other.getReceiverPort()) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            String this$transferToken = this.getTransferToken();
            String other$transferToken = other.getTransferToken();
            if (this$transferToken == null ? other$transferToken != null : !this$transferToken.equals(other$transferToken)) {
                return false;
            }
            InetAddress this$receiverAddress = this.getReceiverAddress();
            InetAddress other$receiverAddress = other.getReceiverAddress();
            return !(this$receiverAddress == null ? other$receiverAddress != null : !((Object)this$receiverAddress).equals(other$receiverAddress));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PendingSendFileTransferPassive;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReceiverPort();
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            String $transferToken = this.getTransferToken();
            result = result * 59 + ($transferToken == null ? 43 : $transferToken.hashCode());
            InetAddress $receiverAddress = this.getReceiverAddress();
            result = result * 59 + ($receiverAddress == null ? 43 : ((Object)$receiverAddress).hashCode());
            return result;
        }

        public static class PendingSendFileTransferPassiveBuilder {
            private User user;
            private String filename;
            private long fileSize;
            private String transferToken;

            PendingSendFileTransferPassiveBuilder() {
            }

            public PendingSendFileTransferPassiveBuilder user(User user) {
                this.user = user;
                return this;
            }

            public PendingSendFileTransferPassiveBuilder filename(String filename) {
                this.filename = filename;
                return this;
            }

            public PendingSendFileTransferPassiveBuilder fileSize(long fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public PendingSendFileTransferPassiveBuilder transferToken(String transferToken) {
                this.transferToken = transferToken;
                return this;
            }

            public PendingSendFileTransferPassive build() {
                return new PendingSendFileTransferPassive(this.user, this.filename, this.fileSize, this.transferToken);
            }

            public String toString() {
                return "DccHandler.PendingSendFileTransferPassive.PendingSendFileTransferPassiveBuilder(user=" + this.user + ", filename=" + this.filename + ", fileSize=" + this.fileSize + ", transferToken=" + this.transferToken + ")";
            }
        }
    }

    protected static class PendingSendFileTransfer
    extends PendingFileTransfer {
        protected final int port;

        public PendingSendFileTransfer(User user, String filename, long fileSize, ServerSocket serverSocket) {
            super(user, filename, fileSize, false);
            this.port = serverSocket.getLocalPort();
            this.serverSocket = serverSocket;
        }

        public static PendingSendFileTransferBuilder builder() {
            return new PendingSendFileTransferBuilder();
        }

        public int getPort() {
            return this.port;
        }

        @Override
        public String toString() {
            return "DccHandler.PendingSendFileTransfer(port=" + this.getPort() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingSendFileTransfer)) {
                return false;
            }
            PendingSendFileTransfer other = (PendingSendFileTransfer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getPort() == other.getPort();
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PendingSendFileTransfer;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPort();
            return result;
        }

        public static class PendingSendFileTransferBuilder {
            private User user;
            private String filename;
            private long fileSize;
            private ServerSocket serverSocket;

            PendingSendFileTransferBuilder() {
            }

            public PendingSendFileTransferBuilder user(User user) {
                this.user = user;
                return this;
            }

            public PendingSendFileTransferBuilder filename(String filename) {
                this.filename = filename;
                return this;
            }

            public PendingSendFileTransferBuilder fileSize(long fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public PendingSendFileTransferBuilder serverSocket(ServerSocket serverSocket) {
                this.serverSocket = serverSocket;
                return this;
            }

            public PendingSendFileTransfer build() {
                return new PendingSendFileTransfer(this.user, this.filename, this.fileSize, this.serverSocket);
            }

            public String toString() {
                return "DccHandler.PendingSendFileTransfer.PendingSendFileTransferBuilder(user=" + this.user + ", filename=" + this.filename + ", fileSize=" + this.fileSize + ", serverSocket=" + this.serverSocket + ")";
            }
        }
    }

    protected static class PendingRecieveFileTransfer
    extends PendingFileTransfer {
        protected final IncomingFileTransferEvent event;

        public PendingRecieveFileTransfer(IncomingFileTransferEvent event, String filename, long fileSize) {
            super(event.getUser(), filename, fileSize, event.isPassive());
            this.event = event;
        }

        public static PendingRecieveFileTransferBuilder builder() {
            return new PendingRecieveFileTransferBuilder();
        }

        public IncomingFileTransferEvent getEvent() {
            return this.event;
        }

        @Override
        public String toString() {
            return "DccHandler.PendingRecieveFileTransfer(event=" + this.getEvent() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingRecieveFileTransfer)) {
                return false;
            }
            PendingRecieveFileTransfer other = (PendingRecieveFileTransfer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IncomingFileTransferEvent this$event = this.getEvent();
            IncomingFileTransferEvent other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !((Object)this$event).equals(other$event));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof PendingRecieveFileTransfer;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IncomingFileTransferEvent $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : ((Object)$event).hashCode());
            return result;
        }

        public static class PendingRecieveFileTransferBuilder {
            private IncomingFileTransferEvent event;
            private String filename;
            private long fileSize;

            PendingRecieveFileTransferBuilder() {
            }

            public PendingRecieveFileTransferBuilder event(IncomingFileTransferEvent event) {
                this.event = event;
                return this;
            }

            public PendingRecieveFileTransferBuilder filename(String filename) {
                this.filename = filename;
                return this;
            }

            public PendingRecieveFileTransferBuilder fileSize(long fileSize) {
                this.fileSize = fileSize;
                return this;
            }

            public PendingRecieveFileTransfer build() {
                return new PendingRecieveFileTransfer(this.event, this.filename, this.fileSize);
            }

            public String toString() {
                return "DccHandler.PendingRecieveFileTransfer.PendingRecieveFileTransferBuilder(event=" + this.event + ", filename=" + this.filename + ", fileSize=" + this.fileSize + ")";
            }
        }
    }

    protected static class PendingSendChatPassive {
        protected final User user;
        protected final String chatToken;
        protected InetAddress receiverAddress;
        protected int receiverPort;

        public PendingSendChatPassive(User user, String chatToken) {
            this.user = user;
            this.chatToken = chatToken;
        }

        public User getUser() {
            return this.user;
        }

        public String getChatToken() {
            return this.chatToken;
        }

        public InetAddress getReceiverAddress() {
            return this.receiverAddress;
        }

        public int getReceiverPort() {
            return this.receiverPort;
        }

        public void setReceiverAddress(InetAddress receiverAddress) {
            this.receiverAddress = receiverAddress;
        }

        public void setReceiverPort(int receiverPort) {
            this.receiverPort = receiverPort;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingSendChatPassive)) {
                return false;
            }
            PendingSendChatPassive other = (PendingSendChatPassive)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getReceiverPort() != other.getReceiverPort()) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            String this$chatToken = this.getChatToken();
            String other$chatToken = other.getChatToken();
            if (this$chatToken == null ? other$chatToken != null : !this$chatToken.equals(other$chatToken)) {
                return false;
            }
            InetAddress this$receiverAddress = this.getReceiverAddress();
            InetAddress other$receiverAddress = other.getReceiverAddress();
            return !(this$receiverAddress == null ? other$receiverAddress != null : !((Object)this$receiverAddress).equals(other$receiverAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PendingSendChatPassive;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getReceiverPort();
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            String $chatToken = this.getChatToken();
            result = result * 59 + ($chatToken == null ? 43 : $chatToken.hashCode());
            InetAddress $receiverAddress = this.getReceiverAddress();
            result = result * 59 + ($receiverAddress == null ? 43 : ((Object)$receiverAddress).hashCode());
            return result;
        }

        public String toString() {
            return "DccHandler.PendingSendChatPassive(user=" + this.getUser() + ", chatToken=" + this.getChatToken() + ", receiverAddress=" + this.getReceiverAddress() + ", receiverPort=" + this.getReceiverPort() + ")";
        }
    }

    public static class PendingFileTransfer {
        protected final User user;
        protected final String filename;
        protected final long fileSize;
        protected final Boolean passive;
        protected Socket socket;
        protected ServerSocket serverSocket;
        protected long position = 0L;

        public PendingFileTransfer(User user, String filename, long fileSize, Boolean passive) {
            this.user = user;
            this.filename = filename;
            this.fileSize = fileSize;
            this.passive = passive;
        }

        public User getUser() {
            return this.user;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public Boolean getPassive() {
            return this.passive;
        }

        public Socket getSocket() {
            return this.socket;
        }

        public ServerSocket getServerSocket() {
            return this.serverSocket;
        }

        public long getPosition() {
            return this.position;
        }

        public void setSocket(Socket socket) {
            this.socket = socket;
        }

        public void setServerSocket(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingFileTransfer)) {
                return false;
            }
            PendingFileTransfer other = (PendingFileTransfer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileSize() != other.getFileSize()) {
                return false;
            }
            if (this.getPosition() != other.getPosition()) {
                return false;
            }
            Boolean this$passive = this.getPassive();
            Boolean other$passive = other.getPassive();
            if (this$passive == null ? other$passive != null : !((Object)this$passive).equals(other$passive)) {
                return false;
            }
            User this$user = this.getUser();
            User other$user = other.getUser();
            if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            Socket this$socket = this.getSocket();
            Socket other$socket = other.getSocket();
            if (this$socket == null ? other$socket != null : !this$socket.equals(other$socket)) {
                return false;
            }
            ServerSocket this$serverSocket = this.getServerSocket();
            ServerSocket other$serverSocket = other.getServerSocket();
            return !(this$serverSocket == null ? other$serverSocket != null : !this$serverSocket.equals(other$serverSocket));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PendingFileTransfer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $fileSize = this.getFileSize();
            result = result * 59 + (int)($fileSize >>> 32 ^ $fileSize);
            long $position = this.getPosition();
            result = result * 59 + (int)($position >>> 32 ^ $position);
            Boolean $passive = this.getPassive();
            result = result * 59 + ($passive == null ? 43 : ((Object)$passive).hashCode());
            User $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            Socket $socket = this.getSocket();
            result = result * 59 + ($socket == null ? 43 : $socket.hashCode());
            ServerSocket $serverSocket = this.getServerSocket();
            result = result * 59 + ($serverSocket == null ? 43 : $serverSocket.hashCode());
            return result;
        }

        public String toString() {
            return "DccHandler.PendingFileTransfer(user=" + this.getUser() + ", filename=" + this.getFilename() + ", fileSize=" + this.getFileSize() + ", passive=" + this.getPassive() + ", socket=" + this.getSocket() + ", serverSocket=" + this.getServerSocket() + ", position=" + this.getPosition() + ")";
        }
    }
}

