/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.cap;

import com.google.common.collect.ImmutableList;
import javax.net.ssl.SSLSocketFactory;
import org.pircbotx.PircBotX;
import org.pircbotx.cap.EnableCapHandler;
import org.pircbotx.exception.CAPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSCapHandler
extends EnableCapHandler {
    private static final Logger log = LoggerFactory.getLogger(TLSCapHandler.class);
    protected SSLSocketFactory sslSocketFactory;

    public TLSCapHandler() {
        super("tls");
        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public TLSCapHandler(SSLSocketFactory sslSocketFactory, boolean ignoreFail) {
        super("tls", ignoreFail);
        this.sslSocketFactory = sslSocketFactory;
    }

    @Override
    public boolean handleACK(PircBotX bot, ImmutableList<String> capabilities) throws CAPException {
        if (capabilities.contains((Object)"tls")) {
            log.debug("Supported capability tls, sending STARTTLS and awaiting 670 response");
            bot.sendRaw().rawLineNow("STARTTLS");
            return false;
        }
        return false;
    }

    @Override
    public boolean handleUnknown(PircBotX bot, String rawLine) {
        return rawLine.contains(" 670 ");
    }

    @Override
    public String toString() {
        return "TLSCapHandler(sslSocketFactory=" + this.getSslSocketFactory() + ")";
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }
}

