/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx.cap;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.pircbotx.PircBotX;
import org.pircbotx.cap.EnableCapHandler;
import org.pircbotx.exception.CAPException;

public class SASLCapHandler
extends EnableCapHandler {
    protected final String username;
    protected final String password;

    public SASLCapHandler(String username, String password) {
        this(username, password, false);
    }

    public SASLCapHandler(String username, String password, boolean ignoreFail) {
        super("sasl", ignoreFail);
        this.username = username;
        this.password = password;
    }

    @Override
    public boolean handleACK(PircBotX bot, ImmutableList<String> capabilities) {
        if (capabilities.contains((Object)"sasl")) {
            bot.sendRaw().rawLineNow("AUTHENTICATE PLAIN");
        }
        return false;
    }

    @Override
    public boolean handleUnknown(PircBotX bot, String rawLine) throws CAPException {
        String[] parsedLine;
        if (rawLine.equals("AUTHENTICATE +")) {
            byte[] rawAuth = (this.username + '\u0000' + this.username + '\u0000' + this.password).getBytes(StandardCharsets.UTF_8);
            String encodedAuth = new String(Base64.encodeBase64((byte[])rawAuth, (boolean)false), StandardCharsets.UTF_8);
            bot.sendRaw().rawLineNow("AUTHENTICATE " + encodedAuth);
        }
        if ((parsedLine = rawLine.split(" ", 4)).length >= 1) {
            if (parsedLine[1].equals("904") || parsedLine[1].equals("905")) {
                bot.getEnabledCapabilities().remove("sasl");
                if (!this.ignoreFail) {
                    throw new CAPException(CAPException.Reason.SASL_FAILED, "SASL Authentication failed with message: " + parsedLine[3].substring(1));
                }
                return true;
            }
            if (parsedLine[1].equals("900") || parsedLine[1].equals("903")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return "SASLCapHandler(username=" + this.username + ")";
    }
}

