/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilSSLSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(UtilSSLSocketFactory.class);
    protected SSLSocketFactory wrappedFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    protected boolean trustingAllCertificates = false;
    protected boolean diffieHellmanDisabled = false;
    protected boolean wrappedFactoryChanged = false;

    public UtilSSLSocketFactory trustAllCertificates() {
        if (this.wrappedFactoryChanged) {
            throw new RuntimeException("Cannot combine trustAllCertificates() and disableDiffieHellman(SSLSocketFactory)");
        }
        if (this.trustingAllCertificates) {
            return this;
        }
        this.trustingAllCertificates = true;
        try {
            TrustManager[] tm = new TrustManager[]{new TrustingX509TrustManager()};
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(new KeyManager[0], tm, new SecureRandom());
            this.wrappedFactory = context.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't recreate socket factory that trusts all certificates", e);
        }
        return this;
    }

    public UtilSSLSocketFactory disableDiffieHellman() {
        this.diffieHellmanDisabled = true;
        return this;
    }

    public UtilSSLSocketFactory disableDiffieHellman(SSLSocketFactory sourceSocketFactory) {
        if (this.trustingAllCertificates) {
            throw new RuntimeException("Cannot combine trustAllCertificates() and disableDiffieHellman(SSLSocketFactory)");
        }
        this.wrappedFactory = sourceSocketFactory;
        this.wrappedFactoryChanged = true;
        return this.disableDiffieHellman();
    }

    protected SSLSocket prepare(Socket socket) {
        SSLSocket sslSocket = (SSLSocket)socket;
        if (this.diffieHellmanDisabled) {
            LinkedList<String> limited = new LinkedList<String>();
            for (String suite : sslSocket.getEnabledCipherSuites()) {
                if (suite.contains("_DHE_")) continue;
                limited.add(suite);
            }
            sslSocket.setEnabledCipherSuites(limited.toArray(new String[limited.size()]));
        }
        return sslSocket;
    }

    @Override
    public SSLSocket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.prepare(this.wrappedFactory.createSocket(host, port));
    }

    @Override
    public SSLSocket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.prepare(this.wrappedFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public SSLSocket createSocket(InetAddress address, int port) throws IOException {
        return this.prepare(this.wrappedFactory.createSocket(address, port));
    }

    @Override
    public SSLSocket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.prepare(this.wrappedFactory.createSocket(address, port, localAddress, localPort));
    }

    @Override
    public SSLSocket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.prepare(this.wrappedFactory.createSocket(s, host, port, autoClose));
    }

    @Override
    public SSLSocket createSocket(Socket socket, InputStream in, boolean bln) throws IOException {
        try {
            return this.prepare((Socket)this.getClass().getMethod("createSocket", Socket.class, InputStream.class, Boolean.TYPE).invoke((Object)this, socket, in, bln));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create socket", e);
        }
    }

    @Override
    public SSLSocket createSocket() throws IOException {
        return this.prepare(this.wrappedFactory.createSocket());
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.wrappedFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.wrappedFactory.getSupportedCipherSuites();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UtilSSLSocketFactory)) {
            return false;
        }
        UtilSSLSocketFactory other = (UtilSSLSocketFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTrustingAllCertificates() != other.isTrustingAllCertificates()) {
            return false;
        }
        if (this.isDiffieHellmanDisabled() != other.isDiffieHellmanDisabled()) {
            return false;
        }
        if (this.wrappedFactoryChanged != other.wrappedFactoryChanged) {
            return false;
        }
        SSLSocketFactory this$wrappedFactory = this.wrappedFactory;
        SSLSocketFactory other$wrappedFactory = other.wrappedFactory;
        return !(this$wrappedFactory == null ? other$wrappedFactory != null : !this$wrappedFactory.equals(other$wrappedFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UtilSSLSocketFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrustingAllCertificates() ? 79 : 97);
        result = result * 59 + (this.isDiffieHellmanDisabled() ? 79 : 97);
        result = result * 59 + (this.wrappedFactoryChanged ? 79 : 97);
        SSLSocketFactory $wrappedFactory = this.wrappedFactory;
        result = result * 59 + ($wrappedFactory == null ? 43 : $wrappedFactory.hashCode());
        return result;
    }

    public String toString() {
        return "UtilSSLSocketFactory(wrappedFactory=" + this.wrappedFactory + ", trustingAllCertificates=" + this.isTrustingAllCertificates() + ", diffieHellmanDisabled=" + this.isDiffieHellmanDisabled() + ", wrappedFactoryChanged=" + this.wrappedFactoryChanged + ")";
    }

    public boolean isTrustingAllCertificates() {
        return this.trustingAllCertificates;
    }

    public boolean isDiffieHellmanDisabled() {
        return this.diffieHellmanDisabled;
    }

    public static class TrustingX509TrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] cert, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

