/*
 * Decompiled with CFR 0.152.
 */
package org.pircbotx;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.pircbotx.PircBotX;
import org.pircbotx.User;
import org.pircbotx.output.OutputUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserHostmask
implements Comparable<User> {
    private static final Logger log = LoggerFactory.getLogger(UserHostmask.class);
    @NonNull
    protected final PircBotX bot;
    protected final AtomicSafeInitializer<OutputUser> output = new AtomicSafeInitializer<OutputUser>(){

        protected OutputUser initialize() {
            return UserHostmask.this.bot.getConfiguration().getBotFactory().createOutputUser(UserHostmask.this.bot, UserHostmask.this);
        }
    };
    private final String extbanPrefix;
    private String nick;
    private String login;
    private String hostname;

    protected UserHostmask(PircBotX bot, String rawHostmask) {
        try {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)rawHostmask), (Object)"Cannot parse blank hostmask");
            this.bot = bot;
            if (StringUtils.contains((CharSequence)rawHostmask, (CharSequence)"!") && StringUtils.contains((CharSequence)rawHostmask, (CharSequence)"@")) {
                String[] hostmaskParts = StringUtils.split((String)rawHostmask, (String)"!@");
                if (hostmaskParts.length >= 3) {
                    this.nick = hostmaskParts[0];
                    this.login = hostmaskParts[1];
                    this.hostname = hostmaskParts[2];
                } else {
                    this.nick = rawHostmask;
                    this.login = null;
                    this.hostname = null;
                }
            } else {
                this.nick = rawHostmask;
                this.login = null;
                this.hostname = null;
            }
            if (this.nick.startsWith(":")) {
                this.nick = this.nick.substring(1);
            }
            if (this.nick.contains(":")) {
                String[] nickParts = StringUtils.split((String)this.nick, (String)":");
                this.extbanPrefix = nickParts[0];
                this.nick = nickParts[1];
            } else {
                this.extbanPrefix = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse hostmask " + rawHostmask, e);
        }
    }

    protected UserHostmask(UserHostmask otherHostmask) {
        this.bot = otherHostmask.getBot();
        this.nick = otherHostmask.getNick();
        this.login = otherHostmask.getLogin();
        this.hostname = otherHostmask.getHostname();
        this.extbanPrefix = otherHostmask.getExtbanPrefix();
    }

    protected void updateHostmask(@NonNull UserHostmask userHostmask) {
        if (userHostmask == null) {
            throw new NullPointerException("userHostmask is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)userHostmask.getHostname()) && !userHostmask.getHostname().equals(this.getHostname())) {
            log.trace("Updating hostname to {} for user {}!{}@{}", new Object[]{userHostmask.getHostname(), this.getNick(), this.getLogin(), this.getHostname()});
            this.hostname = userHostmask.getHostname();
        }
        if (StringUtils.isNotBlank((CharSequence)userHostmask.getLogin()) && !userHostmask.getLogin().equals(this.getLogin())) {
            log.trace("Updating login to {} for user {}!{}@{}", new Object[]{userHostmask.getLogin(), this.getNick(), this.getLogin(), this.getHostname()});
            this.login = userHostmask.getLogin();
        }
    }

    @NonNull
    public String getHostmask() {
        StringBuilder hostmask = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.extbanPrefix)) {
            hostmask.append(this.extbanPrefix).append(':');
        }
        hostmask.append(this.nick);
        if (StringUtils.isNotBlank((CharSequence)this.login) || StringUtils.isNotBlank((CharSequence)this.hostname)) {
            hostmask.append('!').append(this.login).append('@').append(this.hostname);
        }
        return hostmask.toString();
    }

    public String getIdent() {
        return this.getLogin();
    }

    public OutputUser send() {
        try {
            return (OutputUser)this.output.get();
        }
        catch (ConcurrentException ex) {
            throw new RuntimeException("Could not generate OutputChannel for " + this.getNick(), ex);
        }
    }

    @Override
    public int compareTo(User other) {
        return this.getNick().compareToIgnoreCase(other.getNick());
    }

    public <T extends PircBotX> T getBot() {
        return (T)this.bot;
    }

    protected UserHostmask(@NonNull PircBotX bot, String extbanPrefix, String nick, String login, String hostname) {
        if (bot == null) {
            throw new NullPointerException("bot is marked non-null but is null");
        }
        this.bot = bot;
        this.extbanPrefix = extbanPrefix;
        this.nick = nick;
        this.login = login;
        this.hostname = hostname;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserHostmask)) {
            return false;
        }
        UserHostmask other = (UserHostmask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$bot = this.getBot();
        Object other$bot = other.getBot();
        if (this$bot == null ? other$bot != null : !this$bot.equals(other$bot)) {
            return false;
        }
        String this$nick = this.getNick();
        String other$nick = other.getNick();
        if (this$nick == null ? other$nick != null : !this$nick.equals(other$nick)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        return !(this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserHostmask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        String $nick = this.getNick();
        result = result * 59 + ($nick == null ? 43 : $nick.hashCode());
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        return result;
    }

    public String getExtbanPrefix() {
        return this.extbanPrefix;
    }

    public String getNick() {
        return this.nick;
    }

    public String getLogin() {
        return this.login;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String toString() {
        return "UserHostmask(extbanPrefix=" + this.getExtbanPrefix() + ", nick=" + this.getNick() + ", login=" + this.getLogin() + ", hostname=" + this.getHostname() + ")";
    }

    protected void setNick(String nick) {
        this.nick = nick;
    }
}

